/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.MagicKickTrait;

import de.tobiyas.racesandclasses.APIs.SilenceAndKickAPI;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.MCPrettyName;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MagicKickTrait
extends AbstractMagicSpellTrait {
    private double duration = 0.0;
    private int range = 0;

    @Override
    @TraitInfos(category="magic", traitName="MagicKickTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public String getName() {
        return "MagicKickTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Double.class, optional=true), @TraitConfigurationField(fieldName="range", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.duration = configMap.getAsDouble("duration", 0.0);
        this.range = configMap.getAsInt("range", 8);
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (trait instanceof MagicKickTrait) {
            return this.duration > ((MagicKickTrait)trait).duration;
        }
        return false;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        int range = this.modifyToPlayer(player, this.range, "range");
        Object target = SearchEntity.inLineOfSight(range, (LivingEntity)player.getPlayer());
        if (target == null) {
            result.copyFrom(TraitResults.False());
            return;
        }
        double duration = this.modifyToPlayer(player, this.duration, "duration");
        boolean kickedSomething = SilenceAndKickAPI.kickChanneling(target.getUniqueId(), (long)(duration * 1000.0));
        if (kickedSomething) {
            player.sendTranslatedMessage("trait_kick_sucess", "name", this.getNameOfEntity((LivingEntity)target), "duration", String.valueOf((int)duration));
        } else {
            player.sendTranslatedMessage("trait_kick_failed", "name", this.getNameOfEntity((LivingEntity)target));
        }
        result.copyFrom(TraitResults.True());
    }

    @Override
    protected TraitRestriction checkForFurtherRestrictions(EventWrapper wrapper) {
        int range = this.modifyToPlayer(wrapper.getPlayer(), this.range, "range");
        Object target = SearchEntity.inLineOfSight(range, (LivingEntity)wrapper.getPlayer().getPlayer());
        if (target == null) {
            return TraitRestriction.NoTarget;
        }
        return null;
    }

    private String getNameOfEntity(LivingEntity entity) {
        switch (entity.getType()) {
            case PLAYER: {
                return ((Player)entity).getDisplayName();
            }
        }
        return entity.getCustomName() == null ? MCPrettyName.getPrettyName(entity.getType()) : entity.getCustomName();
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "kicks and silences for " + (int)this.duration + " seconds";
    }
}

