/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.MagicHealTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.eventprocessing.events.entitydamage.EntityHealOtherEntityEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class MagicHealTrait
extends AbstractMagicSpellTrait {
    private double value;
    private int blocks = 3;

    @Override
    @TraitInfos(category="magic", traitName="MagicHealTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEntityEvent.class, PlayerInteractEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "MagicHealTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "heals: " + this.value + " max Distance: " + this.blocks;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Double.class), @TraitConfigurationField(fieldName="blocks", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.value = (Double)configMap.get("value");
        if (configMap.containsKey("blocks")) {
            this.blocks = (Integer)configMap.get("blocks");
        }
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof MagicHealTrait)) {
            return false;
        }
        MagicHealTrait otherTrait = (MagicHealTrait)trait;
        return this.value >= otherTrait.value;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait lets you heal others or yourself for a certain value.");
        return helpList;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Player target = null;
        target = player.getPlayer().isSneaking() ? player.getPlayer() : (Player)SearchEntity.inLineOfSight(this.blocks, (LivingEntity)player.getPlayer(), EntityType.PLAYER);
        if (target == null) {
            LanguageAPI.sendTranslatedMessage(player, "no_taget_found");
            result.setTriggered(false);
            return;
        }
        if (target.getLocation().distanceSquared(player.getLocation()) > (double)(this.blocks * this.blocks)) {
            LanguageAPI.sendTranslatedMessage(player, "too_far_away");
            result.setTriggered(false);
            return;
        }
        if (CompatibilityModifier.BukkitPlayer.isFullyHealed(target)) {
            LanguageAPI.sendTranslatedMessage(player, "trait_heal_target_full");
            result.setTriggered(false);
            return;
        }
        double modValue = this.modifyToPlayer(player, this.value, "value");
        EntityHealOtherEntityEvent event = new EntityHealOtherEntityEvent((Entity)target, modValue, EntityRegainHealthEvent.RegainReason.MAGIC, (Entity)player.getPlayer());
        this.plugin.fireEventToBukkit((Event)event);
        if (event.isCancelled()) {
            LanguageAPI.sendTranslatedMessage(player, "trait_failed");
            result.setTriggered(false);
            return;
        }
        double newValue = event.getAmount();
        CompatibilityModifier.BukkitPlayer.safeHeal(newValue, target);
        LanguageAPI.sendTranslatedMessage(player, "trait_healed_target_success", "target", target.getName());
        if (player != target) {
            LanguageAPI.sendTranslatedMessage((CommandSender)target, "trait_healed_other_success", "healer", player.getName());
        }
        result.setTriggered(true);
    }
}

