/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.MagicDamageTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.ParticleEffects;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class MagicDamageTrait
extends AbstractMagicSpellTrait {
    private int range = 4;
    private double damage = 3.0;
    private boolean showLine = true;
    private PotionEffectType potionType = null;
    private int potionAmplifier = 0;
    private int potionDuration = 0;
    private ParticleContainer targetParticles = new ParticleContainer(ParticleEffects.EXPLODE, 1, 0.0f);

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "MagicDamageTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Does damage " + this.range + " blocks away to you.";
    }

    @Override
    @TraitInfos(category="magic", traitName="MagicDamageTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof MagicDamageTrait)) {
            return false;
        }
        MagicDamageTrait otherTrait = (MagicDamageTrait)trait;
        return this.cost > otherTrait.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Does direct magic damage.");
        return helpList;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="range", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="damage", classToExpect=Double.class, optional=true), @TraitConfigurationField(fieldName="targetParticles", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="showLine", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="potionAmplifier", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="potionType", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="potionDuration", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.range = configMap.getAsInt("range", 4);
        this.damage = configMap.getAsDouble("damage", 3.0);
        this.targetParticles = configMap.getAsParticleContainer("targetParticles", this.targetParticles);
        this.potionAmplifier = configMap.getAsInt("potionAmplifier", 0);
        this.potionDuration = configMap.getAsInt("potionDuration", 200);
        this.potionType = configMap.getAsPotionEffectType("potionType", null);
    }

    @Override
    protected TraitRestriction checkForFurtherRestrictions(EventWrapper wrapper) {
        Object targetEntity = SearchEntity.inLineOfSight(80, (LivingEntity)wrapper.getPlayer().getPlayer());
        if (targetEntity == null) {
            return TraitRestriction.NoTarget;
        }
        if (targetEntity.getLocation().distanceSquared(wrapper.getPlayer().getLocation()) > (double)(this.range * this.range)) {
            return TraitRestriction.OutOfRange;
        }
        if (EnemyChecker.areAllies((Entity)wrapper.getPlayer().getPlayer(), targetEntity)) {
            return TraitRestriction.TargetFriendly;
        }
        return super.checkForFurtherRestrictions(wrapper);
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Object targetEntity = SearchEntity.inLineOfSight(this.range, (LivingEntity)player.getPlayer());
        if (targetEntity != null && EnemyChecker.areEnemies((Entity)player.getPlayer(), targetEntity)) {
            LanguageAPI.sendTranslatedMessage(player, "success");
            double modDamage = this.modifyToPlayer(player, this.damage, "damage");
            BukkitRunnable runnable = new BukkitRunnable((LivingEntity)targetEntity, player, modDamage){
                private final /* synthetic */ LivingEntity val$targetEntity;
                private final /* synthetic */ RaCPlayer val$player;
                private final /* synthetic */ double val$modDamage;
                {
                    this.val$targetEntity = livingEntity;
                    this.val$player = raCPlayer;
                    this.val$modDamage = d;
                }

                public void run() {
                    if (this.val$targetEntity.isDead() || !this.val$targetEntity.isValid()) {
                        return;
                    }
                    CompatibilityModifier.LivingEntity.safeDamageEntityByEntity(this.val$targetEntity, (LivingEntity)this.val$player.getPlayer(), this.val$modDamage, EntityDamageEvent.DamageCause.MAGIC);
                    if (MagicDamageTrait.this.potionAmplifier <= 0 || MagicDamageTrait.this.potionType == null || MagicDamageTrait.this.potionDuration <= 0) {
                        return;
                    }
                    int modAmp = MagicDamageTrait.this.modifyToPlayer(this.val$player, MagicDamageTrait.this.potionAmplifier, "potionAmplifier");
                    PotionEffect effect = new PotionEffect(MagicDamageTrait.this.potionType, MagicDamageTrait.this.potionDuration, modAmp);
                    this.val$targetEntity.addPotionEffect(effect);
                }
            };
            if (this.targetParticles != null) {
                if (this.showLine) {
                    int maxTimeToTake = 20;
                    final Queue<Location> onTheWay = SearchEntity.getAllOnWay(player.getLocation().add(0.0, 1.0, 0.0), targetEntity.getEyeLocation());
                    int ticks = maxTimeToTake / onTheWay.size();
                    new BukkitRunnable(){

                        public void run() {
                            if (onTheWay.isEmpty()) {
                                this.cancel();
                                return;
                            }
                            Location next = (Location)onTheWay.poll();
                            Vollotile.get().sendOwnParticleEffectToAll(MagicDamageTrait.this.targetParticles, next);
                        }
                    }.runTaskTimer((Plugin)this.plugin, (long)ticks, (long)ticks);
                    runnable.runTaskLater((Plugin)RacesAndClasses.getPlugin(), 20L);
                } else {
                    Vollotile.get().sendOwnParticleEffectToAll(this.targetParticles, targetEntity.getLocation());
                    runnable.run();
                }
            }
            result.setTriggered(true);
            return;
        }
        result.setTriggered(false);
    }
}

