/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.MagicAreaHealTrait;

import de.tobiyas.racesandclasses.eventprocessing.events.entitydamage.EntityHealOtherEntityEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractActivateAETrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.ParticleEffects;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class MagicAreaHealTrait
extends AbstractActivateAETrait {
    protected double value = 1.0;
    protected ParticleContainer particles = new ParticleContainer(ParticleEffects.HEART, 1, 0.0f);
    protected ParticleContainer particlesFromSelf = null;

    @Override
    public String getName() {
        return "MagicAreaHealTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Double.class, optional=false), @TraitConfigurationField(fieldName="particle", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="particleFromSelf", classToExpect=String.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("value")) {
            this.value = configMap.getAsDouble("value");
        }
        if (configMap.containsKey("particle")) {
            this.particles = configMap.getAsParticleContainer("particle");
        }
        if (configMap.containsKey("particleFromSelf")) {
            this.particlesFromSelf = configMap.getAsParticleContainer("particleFromSelf");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This Trait Does an AOE Heal.");
        return helpList;
    }

    @Override
    @TraitInfos(category="magic", traitName="MagicAreaHealTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
    }

    @Override
    protected boolean triggerOnEntity(RaCPlayer player, Entity otherEntity) {
        if (!(otherEntity instanceof LivingEntity)) {
            return false;
        }
        double modHeal = this.modifyToPlayer(player, this.value, "value");
        EntityHealOtherEntityEvent event = new EntityHealOtherEntityEvent(otherEntity, modHeal, EntityRegainHealthEvent.RegainReason.MAGIC, (Entity)player.getPlayer());
        this.plugin.fireEventToBukkit((Event)event);
        modHeal = event.getAmount();
        if (modHeal <= 0.0 || event.isCancelled()) {
            return false;
        }
        CompatibilityModifier.LivingEntity.safeHealEntity((LivingEntity)otherEntity, modHeal);
        if (this.particles != null) {
            Vollotile.get().sendOwnParticleEffectToAll(this.particles, otherEntity.getLocation());
        }
        if (this.particlesFromSelf != null) {
            Vollotile.get().sendOwnParticleEffectToAll(this.particlesFromSelf, player.getLocation());
        }
        return true;
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Does Heal on Stuff around.";
    }
}

