/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.LightningTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.damage.PreEntityDamageEvent;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class LightningTrait
extends AbstractMagicSpellTrait {
    private double damage = 3.0;
    private double maxDist = 10.0;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "LightningTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Mana: " + this.cost;
    }

    @Override
    @TraitInfos(category="magic", traitName="LightningTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="damage", classToExpect=Double.class, optional=true), @TraitConfigurationField(fieldName="distance", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.damage = configMap.getAsDouble("damage", 3.0);
        this.maxDist = configMap.getAsDouble("distance", 10.0);
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof LightningTrait)) {
            return false;
        }
        LightningTrait otherTrait = (LightningTrait)trait;
        return this.cost > otherTrait.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait triggers a lightning to your target.");
        return helpList;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Object target = SearchEntity.inLineOfSight((int)this.maxDist, (LivingEntity)player.getPlayer());
        if (target == null) {
            result.copyFrom(TraitResults.False());
            LanguageAPI.sendTranslatedMessage(player, "no_taget_found");
            return;
        }
        if (EnemyChecker.areAllies((Entity)player.getPlayer(), target)) {
            LanguageAPI.sendTranslatedMessage(player, "restrictions_not_met_TargetFriendly");
            result.copyFrom(TraitResults.False());
            return;
        }
        Location targetLocation = target.getLocation();
        double modDamage = this.modifyToPlayer(player, this.damage, "damage");
        double realDamage = PreEntityDamageEvent.getRealDamage((Entity)player.getPlayer(), target, EntityDamageEvent.DamageCause.MAGIC, modDamage);
        targetLocation.getWorld().strikeLightningEffect(targetLocation);
        target.damage(realDamage, (Entity)player.getPlayer());
        result.copyFrom(TraitResults.True());
    }

    public static List<LivingEntity> getNearbyEntities(Location location, int radius) {
        int chunkRadius = radius < 16 ? 1 : (radius - radius % 16) / 16;
        LinkedList<LivingEntity> radiusEntities = new LinkedList<LivingEntity>();
        int chX = 0 - chunkRadius;
        while (chX <= chunkRadius) {
            int chZ = 0 - chunkRadius;
            while (chZ <= chunkRadius) {
                int x = (int)location.getX();
                int y = (int)location.getY();
                int z = (int)location.getZ();
                Entity[] entityArray = new Location(location.getWorld(), (double)(x + chX * 16), (double)y, (double)(z + chZ * 16)).getChunk().getEntities();
                int n = entityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Entity e = entityArray[n2];
                    if (e instanceof LivingEntity && e.getLocation().distance(location) <= (double)radius && e.getLocation().getBlock() != location.getBlock()) {
                        radiusEntities.add((LivingEntity)e);
                    }
                    ++n2;
                }
                ++chZ;
            }
            ++chX;
        }
        return radiusEntities;
    }
}

