/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.LightTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractContinousCostMagicSpellTrait;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;

public class LightTrait
extends AbstractContinousCostMagicSpellTrait {
    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class, PlayerMoveEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "LightTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        return "for: " + time + " seconds, mana: " + this.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait lets you fall slower.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        int othertime;
        if (!(trait instanceof LightTrait)) {
            return false;
        }
        LightTrait otherTrait = (LightTrait)trait;
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        int n = othertime = otherTrait.everyXSeconds <= 0 ? otherTrait.durationInSeconds : otherTrait.everyXSeconds;
        return this.cost / (double)time <= otherTrait.cost / (double)othertime;
    }

    @Override
    @TraitInfos(category="magic", traitName="LightTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() == PlayerAction.PLAYER_MOVED) {
            RaCPlayer player = wrapper.getPlayer();
            return this.activePlayersSchedulerMap.containsKey(player.getName());
        }
        return super.canBeTriggered(wrapper);
    }

    @Override
    protected TraitResults otherEventTriggered(EventWrapper eventWrapper, TraitResults result) {
        if (eventWrapper.getEvent() instanceof PlayerMoveEvent) {
            RaCPlayer player = eventWrapper.getPlayer();
            if (!this.activePlayersSchedulerMap.containsKey(player.getName())) {
                return TraitResults.False();
            }
            Location from = ((PlayerMoveEvent)eventWrapper.getEvent()).getFrom().subtract(0.0, 1.0, 0.0);
            Location to = ((PlayerMoveEvent)eventWrapper.getEvent()).getTo().subtract(0.0, 1.0, 0.0);
            if (from.getBlock().equals(to.getBlock())) {
                return TraitResults.False();
            }
            this.setLightUnderPlayer(player, from, to);
            return TraitResults.True();
        }
        return TraitResults.False();
    }

    private void setLightUnderPlayer(RaCPlayer player, Location from, Location to) {
        if (from != null && from.getBlock().getType().isSolid()) {
            player.getPlayer().sendBlockChange(from, from.getBlock().getType().getId(), from.getBlock().getData());
        }
        if (to != null && to.getBlock().getType() != Material.AIR && to.getBlock().getType().isSolid()) {
            player.getPlayer().sendBlockChange(to, Material.GLOWSTONE.getId(), (byte)0);
        }
    }

    @Override
    protected boolean activateIntern(RaCPlayer player) {
        this.setLightUnderPlayer(player, null, player.getLocation().clone().subtract(0.0, 1.0, 0.0));
        return true;
    }

    @Override
    protected boolean deactivateIntern(RaCPlayer player) {
        if (player == null) {
            return true;
        }
        if (!player.isOnline()) {
            return true;
        }
        Location current = player.getLocation().clone().subtract(0.0, 1.0, 0.0);
        player.getPlayer().sendBlockChange(current, current.getBlock().getType().getId(), current.getBlock().getData());
        return true;
    }

    @Override
    public void triggerButDoesNotHaveEnoghCostType(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() == PlayerAction.PLAYER_MOVED) {
            this.trigger(wrapper);
            return;
        }
        super.triggerButDoesNotHaveEnoghCostType(wrapper);
    }

    @Override
    protected boolean tickInternal(RaCPlayer player) {
        return true;
    }
}

