/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.LifeTapTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.eventprocessing.events.mana.ManaRegenerationEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.CostType;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class LifeTapTrait
extends AbstractMagicSpellTrait {
    private Double value = 0.0;

    @Override
    @TraitEventsUsed
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "LifeTapTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.value = (Double)configMap.get("value");
        this.costType = CostType.HEALTH;
    }

    @Override
    protected String getPrettyConfigIntern() {
        return String.valueOf(this.materialForCasting.name()) + ": " + this.value;
    }

    @Override
    @TraitInfos(category="magic", traitName="LifeTapTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof LifeTapTrait)) {
            return false;
        }
        LifeTapTrait otherTrait = (LifeTapTrait)trait;
        return this.value > otherTrait.value;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait converts Health To Mana.");
        return helpList;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        if (player.getManaManager().isManaFull()) {
            LanguageAPI.sendTranslatedMessage(player, "mana_already_full");
            result.setTriggered(false);
            return;
        }
        double modValue = this.modifyToPlayer(player, this.value, "value");
        ManaRegenerationEvent event = new ManaRegenerationEvent(player.getPlayer(), modValue);
        this.plugin.fireEventToBukkit((Event)event);
        double newValue = event.getAmount();
        if (event.isCancelled() || newValue < 0.0) {
            LanguageAPI.sendTranslatedMessage(player, "trait_failed");
            result.setTriggered(false);
            return;
        }
        EntityDamageEvent damageEvent = CompatibilityModifier.EntityDamage.safeCreateEvent((Entity)player.getPlayer(), EntityDamageEvent.DamageCause.MAGIC, this.cost);
        this.plugin.fireEventToBukkit((Event)damageEvent);
        double newDamage = CompatibilityModifier.EntityDamage.safeGetDamage(damageEvent);
        if (event.isCancelled()) {
            newDamage = 0.0;
        }
        if (CompatibilityModifier.BukkitPlayer.safeGetHealth(player.getPlayer()) <= newDamage) {
            LanguageAPI.sendTranslatedMessage(player, "you_would_kill_yourself");
            result.setTriggered(false);
            return;
        }
        player.getManaManager().fillMana(newValue);
        CompatibilityModifier.BukkitPlayer.safeDamage(newDamage, player.getPlayer());
        LanguageAPI.sendTranslatedMessage(player, "trait_lifetap_success", "value", String.valueOf(newValue), "damage", String.valueOf(newDamage));
        result.setTriggered(true);
    }
}

