/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.ItemForManaConsumeTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.events.mana.ManaRegenerationEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.CostType;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.Event;

public class ItemForManaConsumeTrait
extends AbstractMagicSpellTrait {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private Double value = 0.0;

    @Override
    @TraitEventsUsed
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "ItemForManaConsumeTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="item", classToExpect=Material.class), @TraitConfigurationField(fieldName="value", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.cost = Math.floor(this.cost);
        this.value = (Double)configMap.get("value");
        this.costType = CostType.ITEM;
        this.materialForCasting = (Material)configMap.get("item");
        if (this.materialForCasting == null) {
            throw new TraitConfigurationFailedException("Could not identify item to use.");
        }
    }

    @Override
    protected String getPrettyConfigIntern() {
        return String.valueOf(this.cost) + " " + this.materialForCasting.name() + ": " + this.value;
    }

    @Override
    @TraitInfos(category="magic", traitName="ItemForManaConsumeTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof ItemForManaConsumeTrait)) {
            return false;
        }
        ItemForManaConsumeTrait otherTrait = (ItemForManaConsumeTrait)trait;
        return this.value > otherTrait.value;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait converts Items To Mana.");
        return helpList;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        if (player.getManaManager().isManaFull()) {
            LanguageAPI.sendTranslatedMessage(player, "mana_already_full");
            result.setTriggered(false);
            return;
        }
        double modValue = this.modifyToPlayer(player, this.value, "value");
        ManaRegenerationEvent event = new ManaRegenerationEvent(player.getPlayer(), modValue);
        this.plugin.fireEventToBukkit((Event)event);
        double newValue = event.getAmount();
        if (event.isCancelled() || newValue < 0.0) {
            LanguageAPI.sendTranslatedMessage(player, "trait_failed", "name", this.getDisplayName());
            result.setTriggered(false);
            return;
        }
        player.getManaManager().fillMana(newValue);
        LanguageAPI.sendTranslatedMessage(player, "trait_consume_success", "value", String.valueOf(newValue), "material", this.materialForCasting.name());
        result.setTriggered(true).setRemoveCostsAfterTrigger(true);
    }
}

