/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.InvisibleTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractContinousCostMagicSpellTrait;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class InvisibleTrait
extends AbstractContinousCostMagicSpellTrait {
    private boolean abortOnReceiveDamage = false;
    private boolean abortOnDoDamage = false;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class, EntityTargetEvent.class})
    public void generalInit() {
    }

    @Override
    protected TraitResults otherEventTriggered(EventWrapper eventWrapper, TraitResults result) {
        Player player;
        Entity target;
        if (eventWrapper.getEvent() instanceof EntityTargetEvent && (target = ((EntityTargetEvent)eventWrapper.getEvent()).getTarget()) instanceof Player && this.activePlayersSchedulerMap.containsKey((player = (Player)target).getName())) {
            ((EntityTargetEvent)eventWrapper.getEvent()).setCancelled(true);
            return TraitResults.False();
        }
        return super.otherEventTriggered(eventWrapper, result);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDamage(EntityDamageEvent event) {
        RaCPlayer pl;
        if (!this.abortOnReceiveDamage) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event instanceof EnemyChecker.FriendDetectEvent) {
            return;
        }
        if (event.getEntity().getType() == EntityType.PLAYER && this.isActivated(pl = RaCPlayerManager.get().getPlayer(event.getEntity().getUniqueId()))) {
            this.deactivate(pl);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        RaCPlayer pl;
        if (!this.abortOnDoDamage) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event instanceof EnemyChecker.FriendDetectEvent) {
            return;
        }
        if (event.getDamager().getType() == EntityType.PLAYER && this.isActivated(pl = RaCPlayerManager.get().getPlayer(event.getDamager().getUniqueId()))) {
            this.deactivate(pl);
        }
    }

    @Override
    public String getName() {
        return "InvisibleTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        return "duration: " + time + " seconds. Mana: " + this.cost;
    }

    @Override
    @TraitInfos(category="magic", traitName="InvisibleTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        int othertime;
        if (!(trait instanceof InvisibleTrait)) {
            return false;
        }
        InvisibleTrait otherTrait = (InvisibleTrait)trait;
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        int n = othertime = otherTrait.everyXSeconds <= 0 ? otherTrait.durationInSeconds : otherTrait.everyXSeconds;
        return time > othertime;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait makes you invisible.");
        return helpList;
    }

    @Override
    protected boolean activateIntern(RaCPlayer player) {
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        time = this.modifyToPlayer(player, time, "duration");
        LanguageAPI.sendTranslatedMessage(player, "trait_invisible_toggle", "duration", String.valueOf(time));
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_SPLASH_POTION_BREAK, 10.0f, 1.0f);
        this.setInvisibleToEverything(player);
        return true;
    }

    private void setInvisibleToEverything(RaCPlayer player) {
        if (!player.isOnline()) {
            return;
        }
        for (Player otherPlayer : PlayerUtils.getOnlinePlayers()) {
            otherPlayer.hidePlayer(player.getPlayer());
        }
        for (Entity entity : player.getPlayer().getNearbyEntities(100.0, 100.0, 100.0)) {
            Creature creature;
            if (!(entity instanceof Creature) || (creature = (Creature)entity).getTarget() != player) continue;
            creature.setTarget(null);
        }
    }

    private void setVisibleAgain(RaCPlayer player) {
        if (!player.isOnline()) {
            return;
        }
        for (Player otherPlayer : PlayerUtils.getOnlinePlayers()) {
            otherPlayer.showPlayer(player.getPlayer());
        }
    }

    @Override
    protected boolean deactivateIntern(RaCPlayer player) {
        this.setVisibleAgain(player);
        player.sendTranslatedMessage("trait_faded", "name", this.getDisplayName());
        return true;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(classToExpect=Boolean.class, fieldName="removeOnReceiveDamage", optional=true), @TraitConfigurationField(classToExpect=Boolean.class, fieldName="removeOnDoDamage", optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.abortOnReceiveDamage = configMap.getAsBool("removeOnReceiveDamage", false);
        this.abortOnDoDamage = configMap.getAsBool("removeOnDoDamage", false);
    }

    @Override
    protected boolean tickInternal(RaCPlayer player) {
        this.setInvisibleToEverything(player);
        return true;
    }
}

