/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.FlyingTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractContinousCostMagicSpellTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.event.player.PlayerInteractEvent;

public class FlyingTrait
extends AbstractContinousCostMagicSpellTrait {
    private double flyspeed = 0.5;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "FlyingTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        return "duration: " + time + " seconds. Mana: " + this.cost;
    }

    @Override
    @TraitInfos(category="magic", traitName="FlyingTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="speed", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("speed")) {
            this.flyspeed = (Double)configMap.get("speed");
            if (this.flyspeed < 0.05) {
                this.flyspeed = 0.05;
            }
            if (this.flyspeed > 1.0) {
                this.flyspeed = 1.0;
            }
        }
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        int otherTime;
        if (!(trait instanceof FlyingTrait)) {
            return false;
        }
        FlyingTrait otherTrait = (FlyingTrait)trait;
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        int n = otherTime = otherTrait.everyXSeconds <= 0 ? otherTrait.durationInSeconds : otherTrait.everyXSeconds;
        return time > otherTime;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait makes you fly. It's some kind of magic.");
        return helpList;
    }

    @Override
    protected boolean activateIntern(RaCPlayer player) {
        if (player.getPlayer().getGameMode() != GameMode.CREATIVE) {
            player.getPlayer().setAllowFlight(true);
        }
        player.getPlayer().setFlying(true);
        player.getPlayer().setFlySpeed((float)this.flyspeed);
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        time = this.modifyToPlayer(player, time, "duration");
        LanguageAPI.sendTranslatedMessage(player, "trait_fly_toggle", "duration", String.valueOf(time));
        return true;
    }

    @Override
    protected boolean deactivateIntern(RaCPlayer player) {
        if (player.getPlayer().getGameMode() != GameMode.CREATIVE) {
            player.getPlayer().setFlying(false);
            player.getPlayer().setAllowFlight(false);
        }
        player.getPlayer().setFlySpeed(0.1f);
        player.getPlayer().setFallDistance(0.0f);
        return true;
    }

    @Override
    protected boolean tickInternal(RaCPlayer player) {
        return true;
    }
}

