/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.FirebreathTrait;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.CostType;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.damage.PreEntityDamageEvent;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.ParticleEffects;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.BlockIterator;

public class FirebreathTrait
extends AbstractMagicSpellTrait
implements Listener {
    private double damage = 3.0;
    private int range = 4;
    private ParticleContainer particle = new ParticleContainer(ParticleEffects.MOBSPAWNER_FLAMES, 1, 0.0f);

    @Override
    @TraitEventsUsed
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "FirebreathTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return String.valueOf(this.costType.name()) + (this.costType == CostType.ITEM ? " " + this.materialForCasting.name() + " " : " ") + this.cost;
    }

    @Override
    @TraitInfos(category="magic", traitName="FirebreathTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(classToExpect=Double.class, fieldName="damage", optional=true), @TraitConfigurationField(classToExpect=Integer.class, fieldName="range", optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("damage")) {
            this.damage = configMap.getAsDouble("damage");
        }
        if (configMap.containsKey("range")) {
            this.range = configMap.getAsInt("range");
        }
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof FirebreathTrait)) {
            return false;
        }
        FirebreathTrait otherTrait = (FirebreathTrait)trait;
        return this.cost > otherTrait.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This Trait fires fire infront of you.");
        return helpList;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Set<Block> blocks = this.fireLocation((LivingEntity)player.getPlayer());
        for (Block block : blocks) {
            Location loc = block.getLocation();
            int i = 0;
            while (i < 3) {
                Vollotile.get().sendOwnParticleEffectToAll(this.particle, loc);
                ++i;
            }
        }
        Set<LivingEntity> damageing = SearchEntity.allInLineOfSight(this.range, (LivingEntity)player.getPlayer());
        double modDamge = this.modifyToPlayer(player, this.damage, "damage");
        for (LivingEntity target : damageing) {
            if (EnemyChecker.areAllies((Entity)player.getPlayer(), (Entity)target)) continue;
            double realDamage = PreEntityDamageEvent.getRealDamage((Entity)player.getPlayer(), (Entity)target, EntityDamageEvent.DamageCause.MAGIC, modDamge);
            CompatibilityModifier.LivingEntity.safeDamageEntityByEntity(target, (LivingEntity)player.getPlayer(), realDamage);
        }
        result.copyFrom(TraitResults.True());
    }

    protected Set<Block> fireLocation(LivingEntity start) {
        HashSet<Block> blocks = new HashSet<Block>();
        BlockIterator it = new BlockIterator(start);
        int i = 0;
        while (i < this.range) {
            blocks.add(it.next());
            ++i;
        }
        return blocks;
    }
}

