/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.FireballTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.CostType;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.damage.PreEntityDamageEvent;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import de.tobiyas.util.RaC.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.helper.ParticleHelper;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class FireballTrait
extends AbstractMagicSpellTrait {
    private double damage = 3.0;
    private double maxRange = 20.0;
    private final String META_KEY = "RAC_PLAYER_META";
    private static boolean inDamageFunction = false;

    @Override
    public String getName() {
        return "FireballTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return String.valueOf(this.costType.name()) + (this.costType == CostType.ITEM ? " " + this.materialForCasting.name() + " " : " ") + this.cost;
    }

    @Override
    @TraitInfos(category="activate", traitName="FireballTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(classToExpect=Double.class, fieldName="damage", optional=true), @TraitConfigurationField(classToExpect=Double.class, fieldName="range", optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.damage = configMap.getAsDouble("damage", 3.0);
        this.maxRange = configMap.getAsDouble("range", 20.0);
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof FireballTrait)) {
            return false;
        }
        FireballTrait otherTrait = (FireballTrait)trait;
        return this.cost > otherTrait.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait fires a Fireball.");
        return helpList;
    }

    @EventHandler
    public void fireballHit(ProjectileHitEvent event) {
        if (event.getEntity().hasMetadata("RAC_PLAYER_META")) {
            try {
                inDamageFunction = true;
                RaCPlayer shooter = (RaCPlayer)((MetadataValue)event.getEntity().getMetadata("RAC_PLAYER_META").get(0)).value();
                if (!TraitHolderCombinder.checkContainer(shooter, this)) {
                    return;
                }
                ParticleHelper.sendParticleEffectToAll(ParticleEffects.HUGE_EXPLOSION, event.getEntity().getLocation(), new Vector(0.0, 0.1, 0.0), 0.0f, 1);
                event.getEntity().removeMetadata("RAC_PLAYER_META", (Plugin)this.plugin);
                event.getEntity().remove();
                double modDamge = this.modifyToPlayer(shooter, this.damage, "damage");
                List<Entity> nearEntities = SearchEntity.inCircleAround((Entity)event.getEntity(), 4.0);
                for (Entity near : nearEntities) {
                    if (near == shooter.getPlayer() || !(near instanceof LivingEntity)) continue;
                    LivingEntity nearLiving = (LivingEntity)near;
                    if (EnemyChecker.areAllies((Entity)shooter.getPlayer(), near)) continue;
                    double realDamage = PreEntityDamageEvent.getRealDamage((Entity)shooter.getPlayer(), near, EntityDamageEvent.DamageCause.MAGIC, modDamge);
                    CompatibilityModifier.LivingEntity.safeDamageEntityByEntity(nearLiving, (LivingEntity)shooter.getPlayer(), realDamage);
                }
            }
            finally {
                inDamageFunction = false;
            }
        }
    }

    @EventHandler
    public void entityDamageByFireball(EntityDamageByEntityEvent event) {
        if (inDamageFunction) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity damager = event.getDamager();
        if (damager.getType() == EntityType.FIREBALL && damager.hasMetadata("RAC_PLAYER_META")) {
            event.setCancelled(true);
        }
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Vector viewDirection = player.getLocation().getDirection();
        if (viewDirection == null) {
            LanguageAPI.sendTranslatedMessage(player, "no_taget_found");
            result.setTriggered(false);
            return;
        }
        Fireball fireball = (Fireball)player.getPlayer().launchProjectile(Fireball.class);
        fireball.setVelocity(viewDirection);
        fireball.setMetadata("RAC_PLAYER_META", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player));
        fireball.setIsIncendiary(false);
        this.startFireballRangeShortener(fireball);
        LanguageAPI.sendTranslatedMessage(player, "launched_something", "name", "Fireball");
        result.setTriggered(true);
    }

    private void startFireballRangeShortener(final Fireball fireball) {
        new DebugBukkitRunnable("FireballRangeChecker"){
            private final Location start;
            {
                super($anonymous0);
                this.start = fireball2.getLocation();
            }

            @Override
            protected void runIntern() {
                boolean sameWorld = this.start.getWorld() == fireball.getWorld();
                double distSquare = !sameWorld ? 133700.0 : fireball.getLocation().distanceSquared(this.start);
                double maxDistSquare = FireballTrait.this.maxRange * FireballTrait.this.maxRange;
                if (!fireball.isValid() || fireball.isDead() || distSquare > maxDistSquare) {
                    if (!fireball.isDead()) {
                        FireballTrait.this.fireballHit(new ProjectileHitEvent((Projectile)fireball));
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 10L, 10L);
    }
}

