/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.ExplosionTrait;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.CostType;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class ExplosionTrait
extends AbstractMagicSpellTrait {
    private boolean explode = false;
    private int range = 0;
    private double damage = 0.0;
    private UUID lastCaster;

    @Override
    @TraitEventsUsed
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "ExplosionTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return String.valueOf(this.costType.name()) + (this.costType == CostType.ITEM ? " " + this.materialForCasting.name() + " " : " ") + this.cost;
    }

    @Override
    @TraitInfos(category="magic", traitName="ExplosionTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="damage", classToExpect=Double.class), @TraitConfigurationField(fieldName="range", classToExpect=Integer.class), @TraitConfigurationField(fieldName="explode", classToExpect=Boolean.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.damage = configMap.getAsDouble("damage");
        this.range = configMap.getAsInt("range");
        if (configMap.containsKey("explode")) {
            this.explode = configMap.getAsBool("explode");
        }
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof ExplosionTrait)) {
            return false;
        }
        ExplosionTrait otherTrait = (ExplosionTrait)trait;
        return this.cost > otherTrait.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait lets you explode and deal damage to everyone around you.");
        return helpList;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Location location = player.getPlayer().getEyeLocation();
        player.getPlayer().setNoDamageTicks(10);
        location.getWorld().createExplosion(location.getBlock().getRelative(BlockFace.NORTH).getLocation(), 0.0f);
        location.getWorld().createExplosion(location.getBlock().getRelative(BlockFace.EAST).getLocation(), 0.0f);
        location.getWorld().createExplosion(location.getBlock().getRelative(BlockFace.SOUTH).getLocation(), 0.0f);
        location.getWorld().createExplosion(location.getBlock().getRelative(BlockFace.WEST).getLocation(), 0.0f);
        double modDamage = this.modifyToPlayer(player, this.damage, "damage");
        if (this.explode) {
            this.lastCaster = player.getUniqueId();
            if (location.getWorld().createExplosion(location, (float)modDamage)) {
                result.setTriggered(true);
                this.lastCaster = null;
                return;
            }
            this.lastCaster = null;
        }
        List<LivingEntity> entities = ExplosionTrait.getNearbyEntities(location, this.range);
        for (LivingEntity entity : entities) {
            if (entity == player) continue;
            EntityDamageByEntityEvent damageEvent = CompatibilityModifier.EntityDamageByEntity.safeCreateEvent((Entity)player.getPlayer(), (Entity)entity, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, modDamage);
            this.lastCaster = player.getUniqueId();
            this.plugin.fireEventToBukkit((Event)damageEvent);
            this.lastCaster = null;
            double newDamage = CompatibilityModifier.EntityDamage.safeGetDamage((EntityDamageEvent)damageEvent);
            if (damageEvent.isCancelled() || !(newDamage > 0.0)) continue;
            CompatibilityModifier.LivingEntity.safeDamageEntityByEntity(entity, (LivingEntity)player.getPlayer(), newDamage);
        }
        result.setTriggered(true);
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (this.lastCaster == null) {
            return;
        }
        if (event.getEntity().getUniqueId().equals(this.lastCaster)) {
            event.setCancelled(true);
        }
    }

    public static List<LivingEntity> getNearbyEntities(Location location, int radius) {
        int chunkRadius = radius < 16 ? 1 : (radius - radius % 16) / 16;
        LinkedList<LivingEntity> radiusEntities = new LinkedList<LivingEntity>();
        int chX = 0 - chunkRadius;
        while (chX <= chunkRadius) {
            int chZ = 0 - chunkRadius;
            while (chZ <= chunkRadius) {
                int x = (int)location.getX();
                int y = (int)location.getY();
                int z = (int)location.getZ();
                Entity[] entityArray = new Location(location.getWorld(), (double)(x + chX * 16), (double)y, (double)(z + chZ * 16)).getChunk().getEntities();
                int n = entityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Entity e = entityArray[n2];
                    if (e instanceof LivingEntity && e.getLocation().distance(location) <= (double)radius && e.getLocation().getBlock() != location.getBlock()) {
                        radiusEntities.add((LivingEntity)e);
                    }
                    ++n2;
                }
                ++chZ;
            }
            ++chX;
        }
        return radiusEntities;
    }
}

