/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.DamageIncreaseBuffTrait;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractBuffTrait;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class DamageIncreaseBuffTrait
extends AbstractBuffTrait {
    private double percent = 0.1;

    @Override
    @TraitInfos(category="magic", traitName="DamageIncreaseBuffTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitEventsUsed
    public void generalInit() {
        super.generalInit();
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.percent = configMap.getAsDouble("value", 0.1);
    }

    @Override
    public String getName() {
        return "DamageIncreaseBuffTrait";
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return this.percent > ((DamageIncreaseBuffTrait)trait).percent;
    }

    @Override
    protected void buffActivated(RaCPlayer player) {
    }

    @Override
    protected void buffTimeouted(RaCPlayer player) {
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void entityDamage(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (damager.getType() != EntityType.PLAYER) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event instanceof EnemyChecker.FriendDetectEvent) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(damager.getUniqueId());
        if (!TraitHolderCombinder.checkContainer(player, this)) {
            return;
        }
        double value = (this.modifyToPlayer(player, this.percent, "value") + 1.0) * event.getDamage();
        event.setDamage(value);
        this.buffUsed(player);
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "does " + (int)(this.percent * 100.0) + "% more melee damage for " + this.duration + " seconds";
    }
}

