/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.ColdFeetTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.MessageScheduleApi;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.ColdFeetTrait.ScheduleBackToWater;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class ColdFeetTrait
extends AbstractMagicSpellTrait {
    private int duration;
    private boolean turnBack = true;
    private final List<String> coldFeetList = new LinkedList<String>();
    private final List<ScheduleBackToWater> blocks = new LinkedList<ScheduleBackToWater>();

    @Override
    @TraitEventsUsed(bypassClasses={BlockBreakEvent.class}, registerdClasses={PlayerInteractEvent.class, PlayerMoveEvent.class})
    public void generalInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public String getName() {
        return "ColdFeetTrait";
    }

    @EventHandler
    public void onMine(BlockBreakEvent event) {
        for (ScheduleBackToWater block : this.blocks) {
            if (!block.getBlock().equals(event.getBlock())) continue;
            event.setCancelled(true);
            break;
        }
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "for: " + this.duration + " seconds, mana: " + this.cost;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Integer.class), @TraitConfigurationField(fieldName="turnBack", classToExpect=Boolean.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.duration = (Integer)configMap.get("duration");
        if (configMap.containsKey("turnBack")) {
            this.turnBack = (Boolean)configMap.get("turnBack");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait lets you freeze water below your feet.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof ColdFeetTrait)) {
            return false;
        }
        ColdFeetTrait otherTrait = (ColdFeetTrait)trait;
        return this.cost / (double)this.duration <= otherTrait.cost / (double)otherTrait.duration;
    }

    @Override
    @TraitInfos(category="magic", traitName="ColdFeetTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getEvent() instanceof BlockBreakEvent) {
            BlockBreakEvent event = (BlockBreakEvent)wrapper.getEvent();
            for (ScheduleBackToWater thread : this.blocks) {
                if (thread.getBlock() != event.getBlock()) continue;
                event.setCancelled(true);
                return false;
            }
        }
        if (wrapper.getPlayerAction() == PlayerAction.PLAYER_MOVED) {
            return this.coldFeetList.contains(wrapper.getPlayer().getName());
        }
        return super.canBeTriggered(wrapper);
    }

    @Override
    public void triggerButHasRestriction(TraitRestriction restriction, EventWrapper wrapper) {
        super.triggerButHasRestriction(restriction, wrapper);
        if (wrapper.getEvent() instanceof PlayerMoveEvent) {
            if (!this.coldFeetList.contains(wrapper.getPlayer().getName())) {
                return;
            }
            PlayerMoveEvent playerMoveEvent = (PlayerMoveEvent)wrapper.getEvent();
            Player player = playerMoveEvent.getPlayer();
            Location belowPlayerLocation = player.getLocation().subtract(0.0, 1.0, 0.0);
            LinkedList<Block> blocksToCheck = new LinkedList<Block>();
            blocksToCheck.add(belowPlayerLocation.getBlock());
            blocksToCheck.add(belowPlayerLocation.getBlock().getRelative(BlockFace.NORTH));
            blocksToCheck.add(belowPlayerLocation.getBlock().getRelative(BlockFace.EAST));
            blocksToCheck.add(belowPlayerLocation.getBlock().getRelative(BlockFace.SOUTH));
            blocksToCheck.add(belowPlayerLocation.getBlock().getRelative(BlockFace.WEST));
            for (Block block : blocksToCheck) {
                Material blockMaterial = block.getType();
                if (blockMaterial != Material.WATER && blockMaterial != Material.STATIONARY_WATER) continue;
                if (this.turnBack) {
                    new ScheduleBackToWater(block, this.modifyToPlayer(wrapper.getPlayer(), this.duration, "duration"));
                    continue;
                }
                block.setType(Material.ICE);
            }
            return;
        }
    }

    @Override
    protected TraitResults otherEventTriggered(EventWrapper wrapper, TraitResults result) {
        if (wrapper.getEvent() instanceof PlayerMoveEvent) {
            if (!this.coldFeetList.contains(wrapper.getPlayer().getName())) {
                return TraitResults.False();
            }
            PlayerMoveEvent playerMoveEvent = (PlayerMoveEvent)wrapper.getEvent();
            Player player = playerMoveEvent.getPlayer();
            Location belowPlayerLocation = player.getLocation().subtract(0.0, 1.0, 0.0);
            LinkedList<Block> blocksToCheck = new LinkedList<Block>();
            blocksToCheck.add(belowPlayerLocation.getBlock());
            blocksToCheck.add(belowPlayerLocation.getBlock().getRelative(BlockFace.NORTH));
            blocksToCheck.add(belowPlayerLocation.getBlock().getRelative(BlockFace.EAST));
            blocksToCheck.add(belowPlayerLocation.getBlock().getRelative(BlockFace.SOUTH));
            blocksToCheck.add(belowPlayerLocation.getBlock().getRelative(BlockFace.WEST));
            for (Block block : blocksToCheck) {
                Material blockMaterial = block.getType();
                if (blockMaterial != Material.WATER && blockMaterial != Material.STATIONARY_WATER) continue;
                if (this.turnBack) {
                    new ScheduleBackToWater(block, this.modifyToPlayer(wrapper.getPlayer(), this.duration, "duration"));
                    continue;
                }
                block.setType(Material.ICE);
            }
            return TraitResults.False();
        }
        return super.otherEventTriggered(wrapper, result);
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        final String playerName = player.getName();
        if (this.coldFeetList.contains(playerName)) {
            LanguageAPI.sendTranslatedMessage(player, "trait_already_active", "name", this.getDisplayName());
            result.setTriggered(false);
            return;
        }
        this.coldFeetList.add(playerName);
        LanguageAPI.sendTranslatedMessage(player, "trait_toggled", "name", this.getDisplayName());
        MessageScheduleApi.scheduleTranslateMessageToPlayer(playerName, this.duration, "trait_faded", "name", this.getDisplayName());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ColdFeetTrait.this.coldFeetList.remove(playerName);
            }
        }, (long)(20 * this.duration));
        result.setTriggered(true);
    }

    @Override
    public void triggerButDoesNotHaveEnoghCostType(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() == PlayerAction.PLAYER_MOVED) {
            this.trigger(wrapper);
            return;
        }
        super.triggerButDoesNotHaveEnoghCostType(wrapper);
    }
}

