/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.BlockDisguiseTrait;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.util.RaC.player.PlayerUtils;
import de.tobiyas.util.RaC.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class DisguiseData {
    private final RaCPlayer player;
    private final Location location;
    private final Material oldMaterial;
    private final byte oldDamage;
    private final Material fakeMaterial;
    private final byte fakeData;
    private boolean valid = true;
    private int tick = 0;

    public DisguiseData(RaCPlayer player, Block oldBlock, Material fakeMaterial, byte fakeData) {
        this.player = player;
        this.location = player.getLocation().getBlock().getLocation();
        this.oldMaterial = oldBlock.getType();
        this.oldDamage = oldBlock.getData();
        this.fakeMaterial = fakeMaterial;
        this.fakeData = fakeData;
        oldBlock.setType(Material.WEB);
        this.setInvisToAll();
        this.sendFakeBlockToAll();
    }

    public DisguiseData tick() {
        if (!this.valid) {
            return this;
        }
        if (!this.player.isOnline()) {
            this.valid = false;
            return this;
        }
        if (this.location.getBlock().getType() == Material.AIR) {
            this.valid = false;
            return this;
        }
        if (!this.location.getBlock().equals(this.player.getLocation().getBlock())) {
            this.valid = false;
            return this;
        }
        this.sendFakeBlockToAll();
        this.setInvisToAll();
        if (this.tick % 2 == 0) {
            this.sendParticlesToAll();
        }
        ++this.tick;
        return this;
    }

    private void sendFakeBlockToAll() {
        Player player = this.player.getRealPlayer();
        for (Player pl : PlayerUtils.getOnlinePlayers()) {
            if (player.isOnline() && player.getPlayer() == pl) continue;
            pl.sendBlockChange(this.location, this.fakeMaterial, this.fakeData);
        }
    }

    private void sendParticlesToAll() {
        VollotileCodeManager.getVollotileCode().sendParticleEffectToAll(ParticleEffects.TOWN_AURA, this.location.clone().add(Math.random() - 0.5, Math.random() + 0.5, Math.random() - 0.5), new Vector(Math.random() * 0.2 - 0.1, 0.1, Math.random() * 0.2 - 0.1), 0.0f, 1);
    }

    public boolean isStillValid() {
        return this.valid;
    }

    public void restoreOld() {
        Block block = this.location.getBlock();
        block.setType(this.oldMaterial);
        block.setData(this.oldDamage);
        for (Player pl : PlayerUtils.getOnlinePlayers()) {
            pl.sendBlockChange(this.location, this.oldMaterial, this.oldDamage);
            pl.showPlayer(this.player.getPlayer());
        }
        this.setVisibleToAll();
    }

    private void setInvisToAll() {
        if (!this.player.isOnline()) {
            return;
        }
        Player ownPlayer = this.player.getRealPlayer();
        for (Player player : PlayerUtils.getOnlinePlayers()) {
            player.hidePlayer(ownPlayer);
        }
    }

    private void setVisibleToAll() {
        if (!this.player.isOnline()) {
            return;
        }
        Player ownPlayer = this.player.getRealPlayer();
        for (Player player : PlayerUtils.getOnlinePlayers()) {
            player.showPlayer(ownPlayer);
        }
    }

    public RaCPlayer getPlayer() {
        return this.player;
    }

    public Location getLocation() {
        return this.location;
    }
}

