/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.BlockDisguiseTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.BlockDisguiseTrait.DisguiseData;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractContinousCostMagicSpellTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BlockDisguiseTrait
extends AbstractContinousCostMagicSpellTrait {
    private final Set<DisguiseData> data = new HashSet<DisguiseData>();
    private Material disguiseMat = Material.HAY_BLOCK;
    private byte disguiseData = 0;
    private BukkitTask tickTask;

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
        super.generalInit();
        this.tickTask = new DebugBukkitRunnable("DisguiseTraitTick"){

            @Override
            protected void runIntern() {
                Iterator it = BlockDisguiseTrait.this.data.iterator();
                while (it.hasNext()) {
                    DisguiseData data = (DisguiseData)it.next();
                    data.tick();
                    if (data.isStillValid()) continue;
                    data.restoreOld();
                    it.remove();
                    BlockDisguiseTrait.this.deactivate(data.getPlayer());
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 10L, 2L);
    }

    @Override
    public String getName() {
        return "BlockDisguiseTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        return "duration: " + time + " seconds. Mana: " + this.cost;
    }

    @Override
    @TraitInfos(category="magic", traitName="BlockDisguiseTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public void deInit() {
        super.deInit();
        for (DisguiseData data : this.data) {
            data.restoreOld();
        }
        this.data.clear();
        if (this.tickTask != null) {
            this.tickTask.cancel();
        }
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(classToExpect=String.class, fieldName="material", optional=true), @TraitConfigurationField(classToExpect=Integer.class, fieldName="data", optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.disguiseMat = configMap.getAsMaterial("material", Material.HAY_BLOCK);
        this.disguiseData = (byte)configMap.getAsInt("data", 0);
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        int othertime;
        if (!(trait instanceof BlockDisguiseTrait)) {
            return false;
        }
        BlockDisguiseTrait otherTrait = (BlockDisguiseTrait)trait;
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        int n = othertime = otherTrait.everyXSeconds <= 0 ? otherTrait.durationInSeconds : otherTrait.everyXSeconds;
        return time > othertime;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait disquises you as block.");
        return helpList;
    }

    @Override
    protected boolean activateIntern(RaCPlayer player) {
        if (this.getData(player) != null) {
            return false;
        }
        Block block = player.getLocation().getBlock();
        BlockState state = block.getState();
        if (!state.getClass().getSimpleName().equals("CraftBlockState")) {
            return false;
        }
        DisguiseData data = new DisguiseData(player, player.getLocation().getBlock(), this.disguiseMat, this.disguiseData);
        this.data.add(data);
        LanguageAPI.sendTranslatedMessage(player, "trait_toggled", "name", this.getDisplayName());
        return true;
    }

    private DisguiseData getData(RaCPlayer player) {
        for (DisguiseData data : this.data) {
            if (data.getPlayer() != player) continue;
            return data;
        }
        return null;
    }

    @Override
    protected boolean deactivateIntern(RaCPlayer player) {
        DisguiseData data = this.getData(player);
        if (data != null) {
            this.data.remove(data);
        }
        player.sendTranslatedMessage("trait_faded", "name", this.getDisplayName());
        return true;
    }

    @Override
    protected boolean tickInternal(RaCPlayer player) {
        return true;
    }
}

