/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.AbsorbDamageBuffTrait;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractBuffTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class AbsorbDamageBuffTrait
extends AbstractBuffTrait {
    private final Set<EntityDamageEvent.DamageCause> types = new HashSet<EntityDamageEvent.DamageCause>();
    private double value = 1.0;
    private final Map<RaCPlayer, Double> absorbMap = new HashMap<RaCPlayer, Double>();

    @Override
    @TraitEventsUsed
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "AbsorbDamageBuffTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return this.types + " " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="types", classToExpect=List.class, optional=false), @TraitConfigurationField(fieldName="value", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        List<String> typeNames = configMap.getAsStringList("types");
        for (String type : typeNames) {
            EntityDamageEvent.DamageCause cause;
            if (type.equalsIgnoreCase("all")) {
                EntityDamageEvent.DamageCause[] damageCauseArray = EntityDamageEvent.DamageCause.values();
                int n = damageCauseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    cause = damageCauseArray[n2];
                    this.types.add(cause);
                    ++n2;
                }
            }
            cause = null;
            try {
                cause = EntityDamageEvent.DamageCause.valueOf((String)type.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (cause == null) continue;
            this.types.add(cause);
        }
        if (configMap.containsKey("value")) {
            this.value = configMap.getAsDouble("value");
        }
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return true;
    }

    @Override
    @TraitInfos(category="magic", traitName="AbsorbDamageBuffTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This buff increases your next hit with the desired weapon.");
        return helpList;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void entityDamage(EntityDamageByEntityEvent event) {
        if (!this.types.contains(event.getCause())) {
            return;
        }
        Entity damaged = event.getEntity();
        if (!(damaged instanceof Player)) {
            return;
        }
        RaCPlayer damagee = RaCPlayerManager.get().getPlayer((Player)event.getEntity());
        if (!this.absorbMap.containsKey(damagee)) {
            return;
        }
        if (this.isActive(damagee)) {
            double damage = CompatibilityModifier.EntityDamage.safeGetDamage((EntityDamageEvent)event);
            double absorbLeft = this.absorbMap.remove(damagee);
            damage -= absorbLeft;
            absorbLeft = 0.0;
            if (damage < 0.0) {
                absorbLeft = -damage;
                damage = 0.0;
                this.absorbMap.put(damagee, absorbLeft);
            } else {
                this.buffActivated(damagee);
            }
            CompatibilityModifier.EntityDamage.safeSetDamage(damage, (EntityDamageEvent)event);
        }
    }

    @Override
    protected void buffActivated(RaCPlayer player) {
        double modified = this.modifyToPlayer(player, this.value, "value");
        this.absorbMap.put(player, modified);
    }

    @Override
    protected void buffTimeouted(RaCPlayer player) {
        this.absorbMap.remove(player);
    }
}

