/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.arrow.TeleportArrowTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;

public class TeleportArrowTrait
extends AbstractArrow {
    private HashMap<Arrow, Player> shootedArrows = new HashMap();

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "TeleportArrowTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Cooldown: " + this.cooldownTime + " seconds";
    }

    @Override
    protected boolean onShoot(EntityShootBowEvent event) {
        LivingEntity shooter = event.getEntity();
        if (!(shooter instanceof Player)) {
            return false;
        }
        if (!(event.getProjectile() instanceof Arrow)) {
            return false;
        }
        Arrow arrow = (Arrow)event.getProjectile();
        Player player = (Player)event.getEntity();
        this.shootedArrows.put(arrow, player);
        LanguageAPI.sendTranslatedMessage((CommandSender)player, "launched_something", "name", this.getDisplayName());
        return true;
    }

    @Override
    protected boolean onHitEntity(EntityDamageByEntityEvent event) {
        return false;
    }

    @Override
    protected boolean onHitLocation(ProjectileHitEvent event) {
        Arrow arrow = (Arrow)event.getEntity();
        Player player = this.shootedArrows.get(arrow);
        if (player == null) {
            return false;
        }
        this.shootedArrows.remove(arrow);
        Location newLocation = arrow.getLocation();
        Location oldLocation = player.getLocation();
        this.enderEffectOnLocation(oldLocation);
        player.teleport(newLocation);
        return true;
    }

    private void enderEffectOnLocation(Location loc) {
        loc.getWorld().playEffect(loc, Effect.ENDER_SIGNAL, 0);
        loc.setY(loc.getY() + 1.0);
        loc.getWorld().playEffect(loc, Effect.ENDER_SIGNAL, 0);
        loc.setY(loc.getY() + 2.0);
        loc.getWorld().playEffect(loc, Effect.ENDER_SIGNAL, 0);
    }

    @Override
    protected String getArrowName() {
        return "Teleport Arrow";
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "When this arrow hits a target/block,");
        helpList.add(ChatColor.YELLOW + "the player will be teleportet there.");
        helpList.add(ChatColor.YELLOW + "Don't forget, that this trait has uplink.");
        return helpList;
    }

    @Override
    @TraitInfos(category="arrow", traitName="TeleportArrowTrait", visible=true)
    public void importTrait() {
    }
}

