/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.arrow.StunArrowTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.StunAPI;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;

public class StunArrowTrait
extends AbstractArrow {
    private double chance = 0.1;
    private final SecureRandom rand = new SecureRandom();

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "StunArrowTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "stun duration: " + this.duration + " seconds.";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Integer.class), @TraitConfigurationField(fieldName="chance", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.duration = (Integer)configMap.get("duration");
        if (configMap.containsKey("chance")) {
            this.chance = (Double)configMap.get("chance");
        }
    }

    @Override
    protected boolean onShoot(EntityShootBowEvent event) {
        return false;
    }

    @Override
    protected boolean onHitEntity(EntityDamageByEntityEvent event) {
        RaCPlayer racshooter;
        int modDur;
        boolean stunned;
        if (event.isCancelled() || CompatibilityModifier.EntityDamage.safeGetDamage((EntityDamageEvent)event) == 0.0) {
            return false;
        }
        Entity hitTarget = event.getEntity();
        if (!(hitTarget instanceof LivingEntity)) {
            return false;
        }
        if (this.rand.nextDouble() > this.chance) {
            return false;
        }
        Player shooter = null;
        if (event.getDamager() instanceof Arrow) {
            Arrow arrow = (Arrow)event.getDamager();
            if (arrow.getShooter() instanceof Player) {
                shooter = (Player)arrow.getShooter();
            }
        } else if (event.getDamager() instanceof Player) {
            shooter = (Player)event.getDamager();
        }
        if ((stunned = StunAPI.StunEntity.stunEntityForSeconds((Entity)shooter, hitTarget, modDur = this.modifyToPlayer(racshooter = RaCPlayerManager.get().getPlayer(shooter), this.duration, "duration"))) && shooter != null) {
            String enemy = hitTarget instanceof Player ? ((Player)hitTarget).getName() : hitTarget.getType().name();
            LanguageAPI.sendTranslatedMessage((CommandSender)shooter, "trait_stun_arrow_success", "duration", String.valueOf(modDur), "target", enemy);
        }
        return stunned;
    }

    @Override
    protected String getArrowName() {
        return "Stun Arrow";
    }

    @Override
    protected boolean onHitLocation(ProjectileHitEvent event) {
        return false;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "If you hit an enemy with an arrow and choosen the Stun Arrow as current arrow,");
        helpList.add(ChatColor.YELLOW + "He will be stunned.");
        return helpList;
    }

    @Override
    @TraitInfos(category="arrow", traitName="StunArrowTrait", visible=true)
    public void importTrait() {
    }
}

