/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.arrow.QuickArrowShotTrait;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class QuickArrowShotTrait
extends AbstractArrow {
    private int amountArrows = 4;
    private int every = 5;
    private boolean useArrow = true;

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "QuickArrowShotTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "fires " + this.amountArrows + " arrows";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="amount", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="useArrow", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="every", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.amountArrows = configMap.getAsInt("amount", 4);
        this.every = configMap.getAsInt("every", 5);
        this.useArrow = configMap.getAsBool("useArrow", true);
    }

    @Override
    protected boolean onShoot(EntityShootBowEvent event) {
        final Player shooter = (Player)event.getEntity();
        final double speed = event.getProjectile().getVelocity().length();
        int modAmount = this.modifyToPlayer(RaCPlayerManager.get().getPlayer(shooter), this.amountArrows, "amount");
        int i = 1;
        while (i < modAmount) {
            new BukkitRunnable(){

                public void run() {
                    if (QuickArrowShotTrait.this.useArrow && !QuickArrowShotTrait.this.removeArrow(shooter)) {
                        this.cancel();
                        return;
                    }
                    Arrow arrow = (Arrow)shooter.launchProjectile(Arrow.class);
                    Vector vec = arrow.getVelocity().normalize().multiply(speed);
                    arrow.setVelocity(vec);
                }
            }.runTaskLater((Plugin)RacesAndClasses.getPlugin(), (long)(i * this.every));
            ++i;
        }
        return true;
    }

    private boolean removeArrow(Player shooter) {
        int i = 0;
        while (i < shooter.getInventory().getSize()) {
            ItemStack item = shooter.getInventory().getItem(i);
            if (item != null && item.getType() == Material.ARROW) {
                int newValue = item.getAmount() - 1;
                item.setAmount(newValue);
                if (newValue > 0) {
                    shooter.getInventory().setItem(i, item);
                } else {
                    shooter.getInventory().setItem(i, null);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected boolean onHitEntity(EntityDamageByEntityEvent event) {
        return false;
    }

    @Override
    protected String getArrowName() {
        return "QuickArrowShotTrait";
    }

    @Override
    protected boolean onHitLocation(ProjectileHitEvent event) {
        return false;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "You can shoot your arrows with more force.");
        return helpList;
    }

    @Override
    @TraitInfos(category="arrow", traitName="QuickArrowShotTrait", visible=true)
    public void importTrait() {
    }
}

