/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.arrow.PotionArrowTrait;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.friend.TargetType;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionArrowTrait
extends AbstractArrow {
    private PotionEffectType type = PotionEffectType.SLOW;
    private int amplifier = 1;
    private int duration = 10;
    private TargetType target = TargetType.ENEMY;

    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class, PlayerInteractEvent.class, EntityShootBowEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "PotionArrowTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Effect: " + this.totalDamage + " Poison-Damage over " + this.duration + " seconds.";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="type", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="amplifier", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="target", classToExpect=String.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.duration = configMap.getAsInt("duration", 10);
        this.type = configMap.getAsPotionEffectType("type", PotionEffectType.SLOW);
        this.amplifier = configMap.getAsInt("amplifier", 1);
        this.target = configMap.getAsTargetType("target", TargetType.ENEMY);
    }

    @Override
    protected boolean onShoot(EntityShootBowEvent event) {
        return true;
    }

    @Override
    protected boolean onHitEntity(EntityDamageByEntityEvent event) {
        Entity hitTarget = event.getEntity();
        if (!(hitTarget instanceof LivingEntity)) {
            return false;
        }
        if (!EnemyChecker.isApplyable(event.getDamager(), hitTarget, this.target)) {
            return false;
        }
        RaCPlayer shooter = RaCPlayerManager.get().getPlayer((Player)event.getDamager());
        int modAmp = this.modifyToPlayer(shooter, this.amplifier, "amplifier");
        PotionEffect effect = new PotionEffect(this.type, this.duration * 20, modAmp);
        ((LivingEntity)hitTarget).addPotionEffect(effect);
        return true;
    }

    @Override
    protected boolean onHitLocation(ProjectileHitEvent event) {
        return false;
    }

    @Override
    protected String getArrowName() {
        return "Poison Arrow";
    }

    @Override
    @TraitInfos(category="arrow", traitName="PotionArrowTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "When you hit an target with an arrow and the PotionArrowTrait is selected,");
        helpList.add(ChatColor.YELLOW + "the player will get the Potion effect of the Arrow.");
        return helpList;
    }
}

