/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.arrow.PoisonArrowTrait;

import de.tobiyas.racesandclasses.APIs.DotAPI;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DamageType;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DotBuilder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class PoisonArrowTrait
extends AbstractArrow {
    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class, PlayerInteractEvent.class, EntityShootBowEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "PoisonArrowTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "damage: " + this.totalDamage + " Poison-Damage over " + this.duration + " seconds.";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Integer.class), @TraitConfigurationField(fieldName="totalDamage", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.duration = (Integer)configMap.get("duration");
        this.totalDamage = (Double)configMap.get("totalDamage");
    }

    @Override
    protected boolean onShoot(EntityShootBowEvent event) {
        return true;
    }

    @Override
    protected boolean onHitEntity(EntityDamageByEntityEvent event) {
        Entity hitTarget = event.getEntity();
        if (!(hitTarget instanceof LivingEntity)) {
            return false;
        }
        if (EnemyChecker.areAllies(event.getDamager(), hitTarget)) {
            return false;
        }
        Entity damager = event.getDamager();
        if (damager instanceof Arrow) {
            damager = CompatibilityModifier.Shooter.getShooter((Projectile)damager);
        }
        if (!(damager instanceof Player)) {
            return false;
        }
        RaCPlayer shooter = RaCPlayerManager.get().getPlayer((Player)damager);
        double totalDamage = this.modifyToPlayer(shooter, this.totalDamage, "totalDamage") / (double)this.duration;
        DotBuilder builder = new DotBuilder(this.getName(), shooter).setDamageEverySecond().setDamageType(DamageType.POISON).setTotalDamage(totalDamage).setTotalTimeInSeconds(this.duration);
        return DotAPI.addDot((LivingEntity)hitTarget, builder);
    }

    @Override
    protected boolean onHitLocation(ProjectileHitEvent event) {
        return false;
    }

    @Override
    protected String getArrowName() {
        return "Poison Arrow";
    }

    @Override
    @TraitInfos(category="arrow", traitName="PoisonArrowTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "When you hit an enemy with an arrow and the PoisonArrowTrait is selected,");
        helpList.add(ChatColor.YELLOW + "the player will get poison damage periodicaly till the timer is done.");
        return helpList;
    }
}

