/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.arrow.MultishotArrowTrait;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class MultishotArrowTrait
extends AbstractArrow {
    private int amountArrows;
    private boolean useArrow = true;

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "MultishotArrowTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "fires " + this.amountArrows + " arrows";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="amount", classToExpect=Integer.class), @TraitConfigurationField(fieldName="useArrow", classToExpect=Boolean.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.amountArrows = (Integer)configMap.get("amount");
        if (configMap.containsKey("useArrow")) {
            this.useArrow = (Boolean)configMap.get("useArrow");
        }
    }

    @Override
    protected boolean onShoot(EntityShootBowEvent event) {
        Player shooter = (Player)event.getEntity();
        Projectile arrow = (Projectile)event.getProjectile();
        Vector oldVelocity = arrow.getVelocity();
        int angle = 10;
        int currentAngle = 10;
        int modAmount = this.modifyToPlayer(RaCPlayerManager.get().getPlayer(shooter), this.amountArrows, "amount");
        int i = 1;
        while (i < modAmount) {
            currentAngle = (i + 1) / 2 * 10;
            if (this.useArrow && !this.removeArrow(shooter)) {
                return true;
            }
            Vector newVelocity = this.calcNewVelocity(oldVelocity.clone(), currentAngle);
            newVelocity = this.calcNewVelocity(oldVelocity.clone(), currentAngle);
            Arrow rightArrow = (Arrow)shooter.launchProjectile(Arrow.class);
            rightArrow.setVelocity(newVelocity);
            rightArrow.setBounce(false);
            if (!this.useArrow) {
                Vollotile.get().makeArrowPickupable(rightArrow, this.useArrow);
            }
            if (++i < modAmount) {
                if (this.useArrow && !this.removeArrow(shooter)) {
                    return true;
                }
                newVelocity = this.calcNewVelocity(oldVelocity.clone(), -currentAngle);
                Arrow leftArrow = (Arrow)shooter.launchProjectile(Arrow.class);
                leftArrow.setVelocity(newVelocity);
                leftArrow.setBounce(false);
                if (!this.useArrow) {
                    Vollotile.get().makeArrowPickupable(leftArrow, this.useArrow);
                }
            }
            ++i;
        }
        return true;
    }

    private boolean removeArrow(Player shooter) {
        int i = 0;
        while (i < shooter.getInventory().getSize()) {
            ItemStack item = shooter.getInventory().getItem(i);
            if (item != null && item.getType() == Material.ARROW) {
                int newValue = item.getAmount() - 1;
                item.setAmount(newValue);
                if (newValue > 0) {
                    shooter.getInventory().setItem(i, item);
                } else {
                    shooter.getInventory().setItem(i, null);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private Vector calcNewVelocity(Vector clone, int currentAngle) {
        double rad = (double)currentAngle * (Math.PI / 180);
        double x = clone.getX();
        double y = clone.getY();
        double addX = x * Math.cos(rad) - y * Math.sin(rad);
        double addZ = x * Math.sin(rad) + y * Math.cos(rad);
        if (addX < 0.01 && addZ < 0.01) {
            addX = rad;
            addZ = rad;
        }
        Vector additionVector = new Vector(addX, 0.0, addZ);
        clone.add(additionVector);
        return clone;
    }

    @Override
    protected boolean onHitEntity(EntityDamageByEntityEvent event) {
        return false;
    }

    @Override
    protected String getArrowName() {
        return "Mulitshot Arrow";
    }

    @Override
    protected boolean onHitLocation(ProjectileHitEvent event) {
        return false;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "You can shoot your arrows with more force.");
        return helpList;
    }

    @Override
    @TraitInfos(category="arrow", traitName="MultishotArrowTrait", visible=true)
    public void importTrait() {
    }
}

