/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.arrow.MightyArrowTrait;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class MightyArrowTrait
extends AbstractArrow {
    private double additionalDamage = 1.0;

    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class, PlayerInteractEvent.class, EntityShootBowEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "MightyArrowTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Additional damage: " + this.additionalDamage;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="damage", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("damage")) {
            this.additionalDamage = configMap.getAsDouble("damage");
        }
    }

    @Override
    protected boolean onShoot(EntityShootBowEvent event) {
        return true;
    }

    @Override
    protected boolean onHitEntity(EntityDamageByEntityEvent event) {
        Entity hitTarget = event.getEntity();
        if (!(hitTarget instanceof LivingEntity)) {
            return false;
        }
        Entity shooterEntity = event.getDamager();
        if (shooterEntity instanceof Projectile) {
            shooterEntity = CompatibilityModifier.Shooter.getShooter((Projectile)shooterEntity);
        }
        if (shooterEntity.getType() != EntityType.PLAYER) {
            return false;
        }
        if (!EnemyChecker.areEnemies(event.getDamager(), hitTarget)) {
            return false;
        }
        RaCPlayer shooter = RaCPlayerManager.get().getPlayer((Player)shooterEntity);
        double modDamage = this.modifyToPlayer(shooter, this.additionalDamage, "damage");
        double newDamage = modDamage + CompatibilityModifier.EntityDamage.safeGetDamage((EntityDamageEvent)event);
        CompatibilityModifier.EntityDamage.safeSetDamage(newDamage, (EntityDamageEvent)event);
        return false;
    }

    @Override
    protected boolean onHitLocation(ProjectileHitEvent event) {
        return false;
    }

    @Override
    protected String getArrowName() {
        return "MightyArrowTrait";
    }

    @Override
    @TraitInfos(category="arrow", traitName="MightyArrowTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "When you hit an target with an arrow and the MightyArrowTrait is selected,");
        helpList.add(ChatColor.YELLOW + "the target will get More damage by this arrow.");
        return helpList;
    }
}

