/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.arrow.LongArrowTrait;

import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.util.Vector;

public class LongArrowTrait
extends AbstractArrow {
    private double speed;

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "LongArrowTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Arrow speed * " + this.speed;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="speed", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.speed = (Double)configMap.get("speed");
    }

    @Override
    protected boolean onShoot(EntityShootBowEvent event) {
        Projectile arrow = (Projectile)event.getProjectile();
        Vector oldVelocity = arrow.getVelocity();
        Vector newVelocity = oldVelocity.multiply(this.speed);
        arrow.setVelocity(newVelocity);
        return true;
    }

    @Override
    protected boolean onHitEntity(EntityDamageByEntityEvent event) {
        return false;
    }

    @Override
    protected String getArrowName() {
        return "Long Range Arrow";
    }

    @Override
    protected boolean onHitLocation(ProjectileHitEvent event) {
        return false;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "You can shoot your arrows with more force.");
        return helpList;
    }

    @Override
    @TraitInfos(category="arrow", traitName="LongArrowTrait", visible=true)
    public void importTrait() {
    }
}

