/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.arrow.FireArrowTrait;

import de.tobiyas.racesandclasses.APIs.DotAPI;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DamageType;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DotBuilder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;

public class FireArrowTrait
extends AbstractArrow {
    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "FireArrowTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "damage: " + this.totalDamage + " Fire-Damage over " + this.duration + " seconds.";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Integer.class), @TraitConfigurationField(fieldName="totalDamage", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.duration = configMap.getAsInt("duration", 5);
        this.totalDamage = configMap.getAsDouble("totalDamage", 3.0);
    }

    @Override
    protected boolean onShoot(EntityShootBowEvent event) {
        Location loc = event.getEntity().getLocation();
        loc.getWorld().playEffect(loc, Effect.MOBSPAWNER_FLAMES, 0);
        event.getProjectile().setFireTicks(1000000);
        return true;
    }

    @Override
    protected boolean onHitEntity(EntityDamageByEntityEvent event) {
        Entity hitTarget = event.getEntity();
        if (!(hitTarget instanceof LivingEntity)) {
            return false;
        }
        if (EnemyChecker.areAllies(event.getDamager(), hitTarget)) {
            return false;
        }
        Entity damager = event.getDamager();
        if (damager instanceof Arrow) {
            damager = CompatibilityModifier.Shooter.getShooter((Projectile)((Arrow)damager));
        }
        if (!(damager instanceof Player)) {
            return false;
        }
        RaCPlayer shooter = RaCPlayerManager.get().getPlayer((Player)damager);
        if (shooter == null) {
            return false;
        }
        double totalDamage = this.modifyToPlayer(shooter, this.totalDamage, "damage");
        DotBuilder builder = new DotBuilder(this.getName(), shooter).setDamageType(DamageType.FIRE).setDamageEverySecond().setTotalDamage(totalDamage).setTotalTimeInSeconds(this.duration);
        LivingEntity target = (LivingEntity)hitTarget;
        return DotAPI.addDot(target, builder);
    }

    @Override
    protected String getArrowName() {
        return "Fire Arrow";
    }

    @Override
    protected boolean onHitLocation(ProjectileHitEvent event) {
        return false;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "If you hit an enemy with an arrow and choosen the Fire Arrow as current arrow,");
        helpList.add(ChatColor.YELLOW + "He will start burning.");
        return helpList;
    }

    @Override
    @TraitInfos(category="arrow", traitName="FireArrowTrait", visible=true)
    public void importTrait() {
    }
}

