/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.arrow.ExplosiveArrowTrait;

import de.tobiyas.racesandclasses.eventprocessing.TraitEventManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;

public class ExplosiveArrowTrait
extends AbstractArrow {
    private HashMap<Arrow, Player> arrowMap;
    private boolean destroyBlocks = false;

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
        this.arrowMap = new HashMap();
    }

    @Override
    public String getName() {
        return "ExplosiveArrowTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "radius: " + this.duration + " damage: " + this.totalDamage;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="radius", classToExpect=Integer.class), @TraitConfigurationField(fieldName="damage", classToExpect=Double.class), @TraitConfigurationField(fieldName="explode", classToExpect=Boolean.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.duration = configMap.getAsInt("radius");
        this.totalDamage = configMap.getAsDouble("damage");
        if (configMap.containsKey("explode")) {
            this.destroyBlocks = configMap.getAsBool("explode");
        }
    }

    @Override
    protected boolean onShoot(EntityShootBowEvent event) {
        if (!(event.getProjectile() instanceof Arrow)) {
            return false;
        }
        if (!(event.getEntity() instanceof Player)) {
            return false;
        }
        Arrow arrow = (Arrow)event.getProjectile();
        Player player = (Player)event.getEntity();
        this.arrowMap.put(arrow, player);
        return true;
    }

    @Override
    protected boolean onHitEntity(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Arrow)) {
            return false;
        }
        if (!this.arrowMap.containsKey(event.getEntity())) {
            return false;
        }
        Arrow arrow = (Arrow)event.getEntity();
        Location loc = arrow.getLocation();
        return this.explodeAt(arrow, loc);
    }

    private HashSet<LivingEntity> getEntitiesNear(Location loc, int radius) {
        Location locToCheck = loc.getBlock().getLocation();
        HashSet<LivingEntity> entitySet = new HashSet<LivingEntity>();
        for (Entity entity : loc.getWorld().getEntities()) {
            if (!(entity instanceof LivingEntity) || !(entity.getLocation().getBlock().getLocation().distance(locToCheck) < (double)radius)) continue;
            entitySet.add((LivingEntity)entity);
        }
        return entitySet;
    }

    protected boolean explodeAt(Arrow arrow, Location loc) {
        if (this.destroyBlocks) {
            loc.getWorld().createExplosion(loc, (float)this.duration);
            this.arrowMap.remove(arrow);
            return true;
        }
        loc.getWorld().createExplosion(loc, 0.0f);
        HashSet<LivingEntity> damageTo = this.getEntitiesNear(loc, this.duration);
        Player player = this.arrowMap.remove(arrow);
        LivingEntity shooter = CompatibilityModifier.Shooter.getShooter((Projectile)arrow);
        for (LivingEntity entity : damageTo) {
            EntityDamageByEntityEvent newEvent = CompatibilityModifier.EntityDamageByEntity.safeCreateEvent((Entity)shooter, (Entity)entity, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, this.modifyToPlayer(RaCPlayerManager.get().getPlayer(player), this.totalDamage, "damage"));
            TraitEventManager.fireEvent((Event)newEvent);
        }
        return false;
    }

    @Override
    protected boolean onHitLocation(ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof Arrow)) {
            return false;
        }
        if (!this.arrowMap.containsKey(event.getEntity())) {
            return false;
        }
        Arrow arrow = (Arrow)event.getEntity();
        Location loc = arrow.getLocation();
        return this.explodeAt(arrow, loc);
    }

    @Override
    protected String getArrowName() {
        return "Explosive Arrow";
    }

    @Override
    @TraitInfos(category="arrow", traitName="ExplosiveArrowTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "When you fire an Arrow and have selected the ExplosiveArrowTrait, it explodes on hit.");
        return helpList;
    }
}

