/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.arrow.CobWebArrowTrait;

import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.Plugin;

public class CobWebArrowTrait
extends AbstractArrow
implements Listener {
    private int range = 3;
    private int seconds = 5;
    private List<Location> locs = new LinkedList<Location>();

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public String getName() {
        return "CobWebArrowTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "webs " + this.range + " blocks for" + this.seconds + " secs.";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="range", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="time", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("range")) {
            this.range = configMap.getAsInt("range");
        }
        if (configMap.containsKey("time")) {
            this.seconds = configMap.getAsInt("time");
        }
    }

    @Override
    protected boolean onShoot(EntityShootBowEvent event) {
        return true;
    }

    @Override
    protected boolean onHitEntity(EntityDamageByEntityEvent event) {
        Entity hitTarget = event.getEntity();
        if (!(hitTarget instanceof LivingEntity)) {
            return false;
        }
        this.webLocation(hitTarget.getLocation());
        return true;
    }

    @Override
    protected String getArrowName() {
        return "CobWeb Arrow";
    }

    @Override
    protected boolean onHitLocation(ProjectileHitEvent event) {
        this.webLocation(event.getEntity().getLocation());
        return true;
    }

    private void webLocation(Location loc) {
        final LinkedList<Location> toWeb = new LinkedList<Location>();
        toWeb.add(loc.getBlock().getRelative(BlockFace.EAST).getLocation());
        toWeb.add(loc.getBlock().getRelative(BlockFace.NORTH).getLocation());
        toWeb.add(loc.getBlock().getRelative(BlockFace.WEST).getLocation());
        toWeb.add(loc.getBlock().getRelative(BlockFace.SOUTH).getLocation());
        toWeb.add(loc);
        Iterator it = toWeb.iterator();
        while (it.hasNext()) {
            Location toCheck = (Location)it.next();
            if (toCheck.getBlock().getType() == Material.AIR) {
                toCheck.getBlock().setType(Material.WEB);
                this.locs.add(toCheck);
                continue;
            }
            it.remove();
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (Location loc : toWeb) {
                    if (loc.getBlock().getType() != Material.WEB) continue;
                    loc.getBlock().setType(Material.AIR);
                    CobWebArrowTrait.this.locs.remove(loc);
                }
            }
        }, (long)(20 * this.seconds));
    }

    @EventHandler
    public void stopCobWebFarming(BlockBreakEvent event) {
        if (this.locs.contains(event.getBlock().getLocation())) {
            event.getBlock().getWorld().getBlockAt(event.getBlock().getLocation()).setType(Material.AIR);
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "If you hit an enemy with an arrow and choosen the Fire Arrow as current arrow,");
        helpList.add(ChatColor.YELLOW + "He will start burning.");
        return helpList;
    }

    @Override
    @TraitInfos(category="arrow", traitName="CobWebArrowTrait", visible=true)
    public void importTrait() {
    }
}

