/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.TrollBloodTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.MessageScheduleApi;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DamageType;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DotContainer;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;

public class TrollbloodTrait
extends AbstractBasicTrait {
    private int duration = 0;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "TrollbloodTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "duration: " + this.duration + "seconds";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.duration = configMap.getAsInt("duration", 0);
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        PlayerInteractEvent Eevent = (PlayerInteractEvent)event;
        Player player = Eevent.getPlayer();
        int removed = plugin.getDotManager().removeAllDots((LivingEntity)player);
        if (removed <= 0) {
            return TraitResults.False();
        }
        LanguageAPI.sendTranslatedMessage((CommandSender)player, "trait_toggled", "name", this.getDisplayName());
        MessageScheduleApi.scheduleTranslateMessageToPlayer(player.getName(), this.duration, "trait_faded", "name", this.getDisplayName());
        return TraitResults.True();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait removes all dot effects on you.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof TrollbloodTrait)) {
            return false;
        }
        TrollbloodTrait otherTrait = (TrollbloodTrait)trait;
        return this.duration >= otherTrait.duration;
    }

    @Override
    @TraitInfos(category="activate", traitName="TrollBloodTrait", visible=true)
    public void importTrait() {
    }

    @Override
    protected TraitResults bindCastIntern(RaCPlayer player) {
        return this.trigger(EventWrapperFactory.buildOnlyWithplayer(player));
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() != PlayerAction.HIT_BLOCK && wrapper.getPlayerAction() != PlayerAction.HIT_AIR) {
            return false;
        }
        RaCPlayer player = wrapper.getPlayer();
        if (player.getPlayer().getItemInHand().getType() != Material.APPLE) {
            return false;
        }
        Collection<DotContainer> dots = plugin.getDotManager().getAllDotsOnEntity((LivingEntity)player.getPlayer(), DamageType.POISON);
        return dots != null && !dots.isEmpty();
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper wrapper) {
        return false;
    }

    @Override
    public boolean isBindable() {
        return true;
    }
}

