/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.TauntTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.MessageScheduleApi;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.plugin.Plugin;

public class TauntTrait
extends AbstractMagicSpellTrait
implements Listener {
    private Map<String, List<Entity>> tauntMap = new HashMap<String, List<Entity>>();
    private int seconds = 0;
    private int range = 0;

    @Override
    @TraitEventsUsed
    public void generalInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public String getName() {
        return "TauntTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "taunting for " + this.seconds + " seconds.";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="seconds", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="range", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.seconds = configMap.getAsInt("seconds", 3);
        this.range = configMap.getAsInt("range", 5);
    }

    private void removeDead() {
        for (List<Entity> playerTaunts : this.tauntMap.values()) {
            Iterator<Entity> it = playerTaunts.iterator();
            while (it.hasNext()) {
                Entity subject = it.next();
                if (subject != null && !subject.isDead()) continue;
                it.remove();
            }
        }
    }

    private void scheduleTauntRemove(final RaCPlayer player, final Creature target) {
        int modDur = this.modifyToPlayer(player, this.seconds * 20, "seconds");
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                List taunts = (List)TauntTrait.this.tauntMap.get(player.getName());
                taunts.remove(target);
                TauntTrait.this.removeDead();
            }
        }, (long)modDur);
    }

    @EventHandler
    public void OnTargetChange(EntityTargetEvent event) {
        Entity target = event.getEntity();
        for (List<Entity> list : this.tauntMap.values()) {
            for (Entity entity : list) {
                if (!entity.equals(target)) continue;
                event.setCancelled(true);
            }
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait lets you Taunt an enemy.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof TauntTrait)) {
            return false;
        }
        TauntTrait otherTrait = (TauntTrait)trait;
        return this.seconds >= otherTrait.seconds;
    }

    @Override
    @TraitInfos(category="activate", traitName="TauntTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        return false;
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper wrapper) {
        return false;
    }

    @Override
    public boolean notifyTriggeredUplinkTime(EventWrapper wrapper) {
        return true;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Object targetToCheck = SearchEntity.inLineOfSight(this.range, (LivingEntity)player.getPlayer());
        if (!(targetToCheck != null && player.isOnline() && targetToCheck instanceof Creature && targetToCheck.isValid())) {
            result.copyFrom(TraitResults.False());
            return;
        }
        Creature target = (Creature)targetToCheck;
        String targetName = target.getType().name();
        LanguageAPI.sendTranslatedMessage(player, "trait_taunt_success", "target", targetName);
        player.sendMessage(ChatColor.LIGHT_PURPLE + target.getType().name() + ChatColor.GREEN + " taunted.");
        target.setTarget((LivingEntity)player.getPlayer());
        LinkedList<Creature> taunts = this.tauntMap.containsKey(player.getName()) ? this.tauntMap.get(player.getName()) : new LinkedList<Creature>();
        taunts.add(target);
        this.tauntMap.put(player.getName(), taunts);
        MessageScheduleApi.scheduleTranslateMessageToPlayer(player.getName(), this.modifyToPlayer(player, this.seconds, "seconds"), "trait_taunt_fade", "target", targetName);
        this.scheduleTauntRemove(player, target);
        result.copyFrom(TraitResults.True());
    }
}

