/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.SprintTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.MessageScheduleApi;
import de.tobiyas.racesandclasses.configuration.traits.TraitConfig;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectTypeWrapper;

public class SprintTrait
extends AbstractBasicTrait {
    private int value;
    private int duration;
    private static Material itemIDInHand = Material.APPLE;
    private final Set<String> sprinting = new HashSet<String>();

    @Override
    @TraitEventsUsed(registerdClasses={PlayerToggleSprintEvent.class})
    public void generalInit() {
        TraitConfig config = plugin.getConfigManager().getTraitConfigManager().getConfigOfTrait(this.getName());
        if (config != null) {
            itemIDInHand = Material.getMaterial((int)((Integer)config.getValue("trait.iteminhand", Material.APPLE.getId())));
        }
    }

    @Override
    public String getName() {
        return "SprintTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "level(" + this.value + ") for " + this.duration + "seconds";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Integer.class), @TraitConfigurationField(fieldName="value", classToExpect=Integer.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.duration = (Integer)configMap.get("duration");
        this.value = (Integer)configMap.get("value");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        if (!(event instanceof PlayerToggleSprintEvent)) {
            return TraitResults.False();
        }
        PlayerToggleSprintEvent Eevent = (PlayerToggleSprintEvent)event;
        if (!Eevent.isSprinting()) {
            return TraitResults.False();
        }
        Player player = Eevent.getPlayer();
        if (player.getItemInHand().getType() != itemIDInHand) {
            return TraitResults.False();
        }
        LanguageAPI.sendTranslatedMessage((CommandSender)player, "trait_toggled", "name", this.getDisplayName());
        int modDur = this.modifyToPlayer(eventWrapper.getPlayer(), this.duration, "duration");
        player.addPotionEffect(PotionEffectTypeWrapper.SPEED.createEffect(modDur * 20, this.value - 1), true);
        this.sprinting.add(player.getName());
        MessageScheduleApi.scheduleTranslateMessageToPlayer(player.getName(), modDur, "trait_faded", "name", this.getDisplayName());
        this.scheduleRemovalOfName(player.getName());
        return TraitResults.True();
    }

    private void scheduleRemovalOfName(final String name) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                SprintTrait.this.sprinting.remove(name);
            }
        }, (long)(this.duration * 20));
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait lets you sprint (move faster) for a short time.");
        helpList.add(ChatColor.YELLOW + "It can be used by toggleing sprint with a " + ChatColor.LIGHT_PURPLE + itemIDInHand.name() + ChatColor.YELLOW + " in hands.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof SprintTrait)) {
            return false;
        }
        SprintTrait otherTrait = (SprintTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="activate", traitName="SprintTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        Event event = wrapper.getEvent();
        if (!(event instanceof PlayerToggleSprintEvent)) {
            return false;
        }
        PlayerToggleSprintEvent Eevent = (PlayerToggleSprintEvent)event;
        if (!Eevent.isSprinting()) {
            return false;
        }
        if (this.sprinting.contains(Eevent.getPlayer().getName())) {
            return false;
        }
        Player player = Eevent.getPlayer();
        return player.getItemInHand().getType() == itemIDInHand;
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper wrapper) {
        return false;
    }

    @Override
    public boolean notifyTriggeredUplinkTime(EventWrapper wrapper) {
        return false;
    }
}

