/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.PoisonedWeaponTrait;

import de.tobiyas.racesandclasses.APIs.DotAPI;
import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DamageType;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DotBuilder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.PoisonedWeaponTrait.PoisonWeaponListener;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PoisonedWeaponTrait
extends AbstractBasicTrait {
    private double seconds = 0.0;
    private double totalDamage = 0.0;
    private double chance = 0.2;
    private int applications = 10;
    private Material poisonMaterial = Material.RED_ROSE;
    private Random rand = new SecureRandom();
    private PoisonWeaponListener listener;

    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class})
    public void generalInit() {
        this.listener = new PoisonWeaponListener(this, this.applications, this.poisonMaterial);
    }

    @Override
    public void deInit() {
        super.deInit();
        this.listener.shutdown();
        this.listener = null;
    }

    @Override
    public String getName() {
        return "PoisonedWeaponTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Poison damage: " + this.totalDamage + " in " + this.seconds + "s.";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Double.class, optional=false), @TraitConfigurationField(fieldName="totaldamage", classToExpect=Double.class, optional=false), @TraitConfigurationField(fieldName="applications", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="chance", classToExpect=Double.class, optional=true), @TraitConfigurationField(fieldName="poisonMaterial", classToExpect=Material.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.seconds = configMap.getAsDouble("duration");
        this.totalDamage = configMap.getAsDouble("totaldamage");
        this.applications = configMap.getAsInt("applications", 10);
        this.chance = configMap.getAsDouble("chance", 0.2);
        PoisonWeaponListener.PoisonItem = this.poisonMaterial = configMap.getAsMaterial("poisonMaterial", Material.RED_ROSE);
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return TraitResults.False();
        }
        EntityDamageByEntityEvent Eevent = (EntityDamageByEntityEvent)event;
        if (!(Eevent.getDamager() instanceof Player)) {
            return TraitResults.False();
        }
        Player causer = (Player)Eevent.getDamager();
        if (!this.checkItemIsPoisoned(causer.getItemInHand())) {
            return TraitResults.False();
        }
        LivingEntity target = (LivingEntity)Eevent.getEntity();
        double randValue = this.rand.nextDouble();
        if (this.chance > randValue) {
            if (EnemyChecker.areAllies((Entity)causer, (Entity)target)) {
                return TraitResults.False();
            }
            RaCPlayer racCauser = RaCPlayerManager.get().getPlayer(causer);
            double totalDamage = this.modifyToPlayer(racCauser, this.totalDamage, "totalDamage");
            DotBuilder builder = new DotBuilder(this.getName(), RaCPlayerManager.get().getPlayer(causer)).setDamageEverySecond().setDamageType(DamageType.POISON).setTotalDamage(totalDamage).setTotalTimeInSeconds((int)this.seconds);
            if (!DotAPI.addDot(target, builder)) {
                return TraitResults.False();
            }
            String targetName = target instanceof Player ? ((Player)target).getName() : target.getType().name();
            this.reducePoisonOnWeapon(causer.getItemInHand());
            LanguageAPI.sendTranslatedMessage((CommandSender)causer, "trait_poison_success", "target", targetName);
            if (target instanceof Player) {
                LanguageAPI.sendTranslatedMessage((CommandSender)((Player)target), "trait_poison_notify_other", "player", causer.getName());
            }
        }
        return TraitResults.False();
    }

    private void reducePoisonOnWeapon(ItemStack itemInHand) {
        ItemMeta meta = itemInHand.getItemMeta();
        List lore = meta.getLore();
        Iterator loreIt = lore.iterator();
        while (loreIt.hasNext()) {
            String toCheck = (String)loreIt.next();
            if (!toCheck.startsWith(PoisonWeaponListener.poisonRecogString)) continue;
            toCheck = toCheck.replace(PoisonWeaponListener.poisonRecogString, "");
            int value = 0;
            try {
                value = Integer.parseInt(toCheck);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            loreIt.remove();
            if (--value > 0) {
                lore.add(String.valueOf(PoisonWeaponListener.poisonRecogString) + value);
            }
            meta.setLore(lore);
            itemInHand.setItemMeta(meta);
            return;
        }
    }

    private boolean checkItemIsPoisoned(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!stack.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        if (!meta.hasLore()) {
            return false;
        }
        for (String poisonString : meta.getLore()) {
            if (!poisonString.startsWith(PoisonWeaponListener.poisonRecogString)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "When attacking with a Poisoned weapon, it will poison him.");
        helpList.add(ChatColor.YELLOW + "Poison can be added by putting your weapon + a RedRose to a Craftingbench.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof PoisonedWeaponTrait)) {
            return false;
        }
        PoisonedWeaponTrait otherTrait = (PoisonedWeaponTrait)trait;
        return this.totalDamage >= otherTrait.totalDamage;
    }

    @Override
    @TraitInfos(category="activate", traitName="PoisonedWeaponTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() != PlayerAction.DO_DAMAGE) {
            return false;
        }
        RaCPlayer player = wrapper.getPlayer();
        return this.checkItemIsPoisoned(player.getPlayer().getItemInHand());
    }
}

