/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.PoisonedWeaponTrait;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.PoisonedWeaponTrait.PoisonedWeaponTrait;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;

public class PoisonWeaponListener
implements Listener {
    public static Material PoisonItem = Material.RED_ROSE;
    private final PoisonedWeaponTrait trait;
    private final List<ShapelessRecipe> recipes = new LinkedList<ShapelessRecipe>();
    private int applications = 1;
    public static Set<Material> weapons = new HashSet<Material>(Arrays.asList(Material.WOOD_SWORD, Material.STONE_SWORD, Material.GOLD_SWORD, Material.IRON_SWORD, Material.DIAMOND_SWORD, Material.WOOD_AXE, Material.STONE_AXE, Material.GOLD_AXE, Material.IRON_AXE, Material.DIAMOND_AXE, Material.WOOD_HOE, Material.STONE_HOE, Material.GOLD_HOE, Material.IRON_HOE, Material.DIAMOND_HOE, Material.WOOD_SPADE, Material.STONE_SPADE, Material.GOLD_SPADE, Material.IRON_SPADE, Material.DIAMOND_SPADE, Material.WOOD_PICKAXE, Material.STONE_PICKAXE, Material.GOLD_PICKAXE, Material.IRON_PICKAXE, Material.DIAMOND_PICKAXE, Material.SHEARS));
    public static final String poisonRecogString = ChatColor.GREEN + "Poison: ";

    public PoisonWeaponListener(PoisonedWeaponTrait trait, int applications, Material poisonMaterial) {
        this.trait = trait;
        this.applications = applications;
        PoisonItem = poisonMaterial;
        this.initRecipes();
        RacesAndClasses.getPlugin().registerEvents(this);
    }

    private void initRecipes() {
        for (Material mat : weapons) {
            ItemStack result = new ItemStack(mat);
            ItemMeta meta = result.getItemMeta();
            LinkedList<String> lore = new LinkedList<String>();
            lore.add(String.valueOf(poisonRecogString) + this.applications);
            meta.setLore(lore);
            result.setItemMeta(meta);
            ShapelessRecipe recipe = new ShapelessRecipe(result);
            recipe.addIngredient(1, mat, Short.MAX_VALUE);
            recipe.addIngredient(PoisonItem);
            boolean worked = Bukkit.addRecipe((Recipe)recipe);
            if (!worked) continue;
            this.recipes.add(recipe);
        }
    }

    public void deregister() {
        Iterator recipeIt = Bukkit.recipeIterator();
        while (recipeIt.hasNext()) {
            Recipe toInvestigate = (Recipe)recipeIt.next();
            if (!(toInvestigate instanceof ShapelessRecipe)) continue;
            ShapelessRecipe bukkitRecipt = (ShapelessRecipe)toInvestigate;
            ItemStack bukkitResult = bukkitRecipt.getResult();
            List bukkitIngredients = bukkitRecipt.getIngredientList();
            for (ShapelessRecipe recipe : this.recipes) {
                ItemStack ownResult = recipe.getResult();
                List ownIngredients = recipe.getIngredientList();
                if (ownResult.getType() != bukkitResult.getType() || ownResult.getDurability() != bukkitResult.getDurability()) continue;
                boolean isRecipe = true;
                for (ItemStack bukkitIngredient : bukkitIngredients) {
                    boolean found = false;
                    for (ItemStack ownIngredient : ownIngredients) {
                        if (ownIngredient.getType() != bukkitIngredient.getType() || ownIngredient.getDurability() != bukkitIngredient.getDurability()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    isRecipe = false;
                    break;
                }
                if (!isRecipe) continue;
                try {
                    recipeIt.remove();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
    }

    public void shutdown() {
        this.deregister();
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void OnPoisonOnWeapon(CraftItemEvent event) {
        Recipe recipe = event.getRecipe();
        ItemStack toCheck = recipe.getResult();
        if (!weapons.contains(toCheck.getType())) {
            return;
        }
        if (!toCheck.hasItemMeta()) {
            return;
        }
        ItemMeta meta = toCheck.getItemMeta();
        if (!meta.hasLore()) {
            return;
        }
        boolean hasPoison = false;
        for (String lore : meta.getLore()) {
            if (!lore.startsWith(poisonRecogString)) continue;
            hasPoison = true;
            break;
        }
        if (!hasPoison) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)event.getWhoClicked().getUniqueId());
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        if (!TraitHolderCombinder.checkContainer(racPlayer, this.trait)) {
            event.setCancelled(true);
        }
    }

    private RaCPlayer getFirst(Collection<HumanEntity> collection) {
        for (HumanEntity entity : collection) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            return RaCPlayerManager.get().getPlayer(player);
        }
        return null;
    }

    @EventHandler
    public void OnPoisonOnWeaponBefore(PrepareItemCraftEvent event) {
        RaCPlayer player = this.getFirst(event.getViewers());
        Recipe recipe = event.getRecipe();
        for (Recipe recipe2 : this.recipes) {
            if (!recipe2.getResult().isSimilar(recipe.getResult())) continue;
            ItemStack[] itemStackArray = event.getInventory().getMatrix();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack item = itemStackArray[n2];
                if (item != null && item.getType() != PoisonItem && item.getType() != Material.AIR) {
                    if (player != null && !TraitHolderCombinder.checkContainer(player, this.trait)) {
                        event.getInventory().setResult(null);
                        return;
                    }
                    ItemStack newItem = item.clone();
                    ItemMeta meta = newItem.getItemMeta();
                    List lore = meta.hasLore() ? meta.getLore() : new LinkedList();
                    Iterator loreIt = lore.iterator();
                    while (loreIt.hasNext()) {
                        if (!((String)loreIt.next()).startsWith(poisonRecogString)) continue;
                        loreIt.remove();
                    }
                    lore.add(String.valueOf(poisonRecogString) + this.applications);
                    meta.setLore(lore);
                    newItem.setItemMeta(meta);
                    event.getInventory().setResult(newItem);
                }
                ++n2;
            }
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        if (!item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasLore()) {
            return;
        }
        List lore = meta.getLore();
        Iterator loreIt = lore.iterator();
        while (loreIt.hasNext()) {
            String currentLore = (String)loreIt.next();
            if (!currentLore.startsWith(poisonRecogString)) continue;
            loreIt.remove();
            break;
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public void setMat(Material newMat) {
        this.deregister();
        PoisonItem = newMat;
        this.initRecipes();
    }
}

