/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.MeleeDotTrait;

import de.tobiyas.racesandclasses.APIs.DotAPI;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DamageType;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DotBuilder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;

public class MeleeDotTrait
extends AbstractBasicTrait {
    private DotBuilder dotBuilderToApply = null;
    private int range = 4;

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
        plugin.registerEvents(this);
    }

    @Override
    public String getName() {
        return "MeleeDotTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "fire a Grappling hook.";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="damage", classToExpect=Double.class, optional=true), @TraitConfigurationField(fieldName="duration", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="damageEvery", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="damageType", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="range", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.range = configMap.getAsInt("range", 3);
        double damage = configMap.getAsDouble("damage", 2.0);
        int duration = configMap.getAsInt("duration", 4) * 20;
        int damageEvery = configMap.getAsInt("damageEvery", 20);
        String type = configMap.getAsString("damageType", DamageType.BLEEDING.name()).toUpperCase();
        this.dotBuilderToApply = new DotBuilder(this.getName()).setTotalDamage(damage).setTotalTimeInSeconds(duration).setDamageEveryTicks(damageEvery).setDamageType(DamageType.parse(type));
        if (!this.dotBuilderToApply.valid()) {
            throw new TraitConfigurationFailedException(String.valueOf(this.getName()) + " Dot-Properties are not valid!", (AbstractTraitHolder)this.holders.iterator().next());
        }
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        return TraitResults.False();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Put a DoT on your enemy.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    @TraitInfos(category="activate", traitName="MeleeDotTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper wrapper) {
        return true;
    }

    @Override
    public boolean notifyTriggeredUplinkTime(EventWrapper wrapper) {
        return true;
    }

    @Override
    public boolean isBindable() {
        return true;
    }

    @Override
    protected TraitResults bindCastIntern(RaCPlayer player) {
        Object target = SearchEntity.inLineOfSight(this.modifyToPlayer(player, this.range, "range"), (LivingEntity)player.getPlayer());
        if (target == null) {
            player.sendTranslatedMessage("no_taget_found");
            return TraitResults.False();
        }
        DotBuilder builder = this.dotBuilderToApply.copy();
        builder.setDamager(player);
        builder.setTotalDamage(this.modifyToPlayer(player, builder.getTotalDamage(), "damage"));
        builder.setTotalTimeInTicks(this.modifyToPlayer(player, builder.getTotalTimeInTicks(), "duration"));
        DotAPI.addDot(target, this.dotBuilderToApply);
        return TraitResults.True();
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        return false;
    }
}

