/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.HealOthersTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.configuration.traits.TraitConfig;
import de.tobiyas.racesandclasses.eventprocessing.TraitEventManager;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.eventprocessing.events.entitydamage.EntityHealOtherEntityEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class HealOthersTrait
extends AbstractBasicTrait {
    private double value;
    private static Material itemIDInHand = Material.STRING;
    private static boolean consume = true;

    @Override
    @TraitInfos(category="activate", traitName="HealOthersTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEntityEvent.class, PlayerInteractEvent.class})
    public void generalInit() {
        TraitConfig config = plugin.getConfigManager().getTraitConfigManager().getConfigOfTrait(this.getName());
        if (config != null) {
            itemIDInHand = Material.getMaterial((int)((Integer)config.getValue("trait.iteminhand", Material.STRING.getId())));
            consume = (Boolean)config.getValue("trait.consume", true);
        }
    }

    @Override
    public String getName() {
        return "HealOthersTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "heals: " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.value = (Double)configMap.get("value");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        if (event instanceof PlayerInteractEntityEvent || event instanceof PlayerInteractEvent) {
            boolean isSneaking = ((PlayerEvent)event).getPlayer().isSneaking();
            if (!isSneaking) {
                return TraitResults.False();
            }
            if (event instanceof PlayerInteractEntityEvent) {
                PlayerInteractEntityEvent Eevent = (PlayerInteractEntityEvent)event;
                Entity target = Eevent.getRightClicked();
                if (target != null && target instanceof Player) {
                    return new TraitResults(this.playerInteractsWithPlayer(Eevent.getPlayer(), (Player)target));
                }
                return TraitResults.False();
            }
            if (event instanceof PlayerInteractEvent) {
                PlayerInteractEvent Eevent = (PlayerInteractEvent)event;
                Action action = Eevent.getAction();
                if (action == Action.RIGHT_CLICK_AIR) {
                    Player player = Eevent.getPlayer();
                    return new TraitResults(this.playerInteractWithSelf(player));
                }
                return TraitResults.False();
            }
        }
        return TraitResults.False();
    }

    private boolean playerInteractWithSelf(Player player) {
        double maxHealth = CompatibilityModifier.BukkitPlayer.safeGetMaxHealth(player);
        double currentHealth = CompatibilityModifier.BukkitPlayer.safeGetHealth(player);
        if (currentHealth >= maxHealth) {
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "trait_heal_target_full");
            return false;
        }
        double amount = this.modifyToPlayer(RaCPlayerManager.get().getPlayer(player), this.value, "value");
        if (currentHealth + amount > maxHealth) {
            amount = maxHealth - currentHealth;
        }
        EntityHealOtherEntityEvent entityHealEvent = new EntityHealOtherEntityEvent((Entity)player, amount, EntityRegainHealthEvent.RegainReason.MAGIC, (Entity)player);
        TraitEventManager.fireEvent((Event)entityHealEvent);
        if (entityHealEvent.isCancelled()) {
            return false;
        }
        amount = CompatibilityModifier.EntityHeal.safeGetAmount(entityHealEvent);
        if (currentHealth + amount > maxHealth) {
            amount = maxHealth - currentHealth;
        }
        if (!entityHealEvent.isCancelled() && amount >= 0.0) {
            double newHealth = currentHealth + amount;
            CompatibilityModifier.BukkitPlayer.safeSetHealth(newHealth, player);
            Location loc = entityHealEvent.getEntity().getLocation();
            loc.getWorld().playEffect(loc, Effect.POTION_BREAK, 1);
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "trait_healed_target_success", "target", player.getName());
            if (consume) {
                int newAmount = player.getItemInHand().getAmount() - 1;
                if (newAmount == 0) {
                    player.setItemInHand(new ItemStack(Material.AIR));
                } else {
                    player.getItemInHand().setAmount(newAmount);
                }
            }
            return true;
        }
        return false;
    }

    private boolean playerInteractsWithPlayer(Player playerInteracting, Player target) {
        double maxHealth = CompatibilityModifier.BukkitPlayer.safeGetMaxHealth(target);
        double currentHealth = CompatibilityModifier.BukkitPlayer.safeGetHealth(target);
        if (currentHealth >= maxHealth) {
            LanguageAPI.sendTranslatedMessage((CommandSender)playerInteracting, "trait_heal_target_full");
            return false;
        }
        double amount = this.modifyToPlayer(RaCPlayerManager.get().getPlayer(playerInteracting), this.value, "value");
        if (currentHealth + amount > maxHealth) {
            amount = maxHealth - currentHealth;
        }
        Player targetPlayer = target;
        EntityHealOtherEntityEvent entityHealEvent = new EntityHealOtherEntityEvent((Entity)targetPlayer, this.value, EntityRegainHealthEvent.RegainReason.MAGIC, (Entity)playerInteracting);
        TraitEventManager.fireEvent((Event)entityHealEvent);
        if (entityHealEvent.isCancelled()) {
            return false;
        }
        amount = CompatibilityModifier.EntityHeal.safeGetAmount(entityHealEvent);
        if (currentHealth + amount > maxHealth) {
            amount = maxHealth - currentHealth;
        }
        if (!entityHealEvent.isCancelled() && amount != 0.0) {
            double newHealth = currentHealth + amount;
            CompatibilityModifier.BukkitPlayer.safeSetHealth(newHealth, target);
            Location loc = entityHealEvent.getEntity().getLocation();
            loc.getWorld().playEffect(loc, Effect.POTION_BREAK, 1);
            LanguageAPI.sendTranslatedMessage((CommandSender)playerInteracting, "trait_healed_target_success", "target", target.getName());
            LanguageAPI.sendTranslatedMessage((CommandSender)targetPlayer, "trait_healed_other_success", "healer", playerInteracting.getName());
            if (consume) {
                int newAmount = playerInteracting.getItemInHand().getAmount() - 1;
                if (newAmount == 0) {
                    playerInteracting.setItemInHand(new ItemStack(Material.AIR));
                } else {
                    playerInteracting.getItemInHand().setAmount(newAmount);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof HealOthersTrait)) {
            return false;
        }
        HealOthersTrait otherTrait = (HealOthersTrait)trait;
        return this.value >= otherTrait.value;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait lets you heal others or yourself for a certain value.");
        helpList.add(ChatColor.YELLOW + "It can be used by right-clicking another player with a " + ChatColor.LIGHT_PURPLE + itemIDInHand.name() + ChatColor.YELLOW + " in hands.");
        return helpList;
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper wrapper) {
        RaCPlayer player = wrapper.getPlayer();
        return player.getPlayer().getItemInHand().getType() != itemIDInHand;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        PlayerAction action = wrapper.getPlayerAction();
        RaCPlayer player = wrapper.getPlayer();
        if (action == PlayerAction.INTERACT_ENTITY || action == PlayerAction.INTERACT_BLOCK || action == PlayerAction.INTERACT_AIR) {
            boolean isSneaking = player.getPlayer().isSneaking();
            if (!isSneaking) {
                return false;
            }
            if (action == PlayerAction.INTERACT_ENTITY) {
                Entity target = wrapper.getEntityTarget();
                if (target != null && target instanceof Player) {
                    return player.getPlayer().getItemInHand().getType() == itemIDInHand;
                }
                return false;
            }
            if (action == PlayerAction.INTERACT_AIR || action == PlayerAction.INTERACT_BLOCK) {
                return player.getPlayer().getItemInHand().getType() == itemIDInHand;
            }
        }
        return false;
    }
}

