/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.GrapplingHookTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import de.tobiyas.util.RaC.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GrapplingHookTrait
extends AbstractBasicTrait {
    private Material materialToUse = Material.ARROW;
    private final Map<Projectile, UUID> launchMap = new HashMap<Projectile, UUID>();
    private Set<UUID> pulling = new HashSet<UUID>();
    private boolean isGrapplingTeleport = false;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class, ProjectileHitEvent.class})
    public void generalInit() {
        plugin.registerEvents(this);
    }

    @Override
    public String getName() {
        return "GrapplingHookTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "fire a Grappling hook.";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="material", classToExpect=Material.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.materialToUse = configMap.getAsMaterial("material");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        if (event instanceof PlayerInteractEvent) {
            PlayerInteractEvent Eevent = (PlayerInteractEvent)event;
            Player player = Eevent.getPlayer();
            if (this.pulling.contains(player.getUniqueId())) {
                return TraitResults.False();
            }
            Arrow projectile = (Arrow)player.launchProjectile(Arrow.class);
            this.launchMap.put((Projectile)projectile, player.getUniqueId());
            return TraitResults.True();
        }
        if (event instanceof ProjectileHitEvent) {
            ProjectileHitEvent hitEvent = (ProjectileHitEvent)event;
            Projectile projectile = hitEvent.getEntity();
            Player player = Bukkit.getPlayer((UUID)this.launchMap.get(projectile));
            this.launchMap.remove(projectile);
            projectile.remove();
            if (this.pulling.contains(player.getUniqueId())) {
                return TraitResults.False();
            }
            if (player.isOnline()) {
                this.pullPlayerTo(player, projectile.getLocation());
            }
        }
        return TraitResults.True();
    }

    @EventHandler
    public void playerMove(PlayerMoveEvent event) {
        if (this.isGrapplingTeleport) {
            return;
        }
        if (event.getFrom().distance(event.getTo()) < 0.1) {
            return;
        }
        Player player = event.getPlayer();
        if (this.pulling.contains(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerLeave(PlayerQuitEvent event) {
        Player pl = event.getPlayer();
        if (this.pulling.contains(pl.getUniqueId())) {
            pl.setAllowFlight(false);
            pl.setFlying(false);
        }
    }

    private void pullPlayerTo(final Player player, final Location location) {
        final boolean isFlying = player.isFlying();
        final boolean allowFlying = player.getAllowFlight();
        if (!isFlying) {
            player.setFlying(true);
            player.setAllowFlight(true);
        }
        this.pulling.add(player.getUniqueId());
        DebugBukkitRunnable runnable = new DebugBukkitRunnable("GrapplingHookPull"){
            int i;
            double dist;
            {
                super($anonymous0);
                this.i = 0;
                this.dist = 100000.0;
            }

            @Override
            public void runIntern() {
                if (this.i++ > 100) {
                    this.stopIt();
                    return;
                }
                if (!player.isOnline() || player.isDead()) {
                    this.stopIt();
                    return;
                }
                Location playerLocation = player.getLocation();
                double curDist = playerLocation.distance(location);
                if (Math.abs(curDist - this.dist) < 0.4) {
                    this.stopIt();
                    return;
                }
                this.dist = curDist;
                if (playerLocation.distance(location) < 1.0 || GrapplingHookTrait.this.launchMap.values().contains(player.getName())) {
                    this.stopIt();
                    return;
                }
                Vector vec = location.toVector().subtract(playerLocation.toVector());
                vec.normalize().multiply(1.4);
                Location teleportLocation = playerLocation.add(vec);
                Location up = teleportLocation.clone().add(0.0, 2.0, 0.0);
                if (up.getBlock().getType().isSolid()) {
                    this.stopIt();
                    return;
                }
                GrapplingHookTrait.this.isGrapplingTeleport = true;
                player.teleport(teleportLocation);
                GrapplingHookTrait.this.isGrapplingTeleport = false;
                player.setFlying(true);
                if (this.i % 2 == 0) {
                    List<Location> between = this.getBetween(playerLocation, location, 10);
                    for (Location loc : between) {
                        VollotileCodeManager.getVollotileCode().sendParticleEffectToAll(ParticleEffects.CRIT, loc, new Vector(0, 0, 0), 0.0f, 3);
                    }
                }
            }

            private void stopIt() {
                GrapplingHookTrait.this.pulling.remove(player.getUniqueId());
                this.cancel();
                try {
                    if (!isFlying) {
                        player.setFlying(false);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (!allowFlying) {
                        player.setAllowFlight(false);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            private List<Location> getBetween(Location start, Location end, int amount) {
                start = start.clone();
                end = end.clone();
                Vector vec = end.toVector().subtract(start.toVector());
                vec = vec.divide(new Vector(amount, amount, amount));
                LinkedList<Location> locs = new LinkedList<Location>();
                int i = 1;
                while (i < amount) {
                    start.add(vec);
                    locs.add(start.clone());
                    ++i;
                }
                return locs;
            }
        };
        runnable.runTaskTimer((Plugin)plugin, 2L, 2L);
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "You fire a grappling hook which lifts you.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    @TraitInfos(category="activate", traitName="GrapplingHookTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        Projectile projectile;
        Event event = wrapper.getEvent();
        if (event instanceof PlayerInteractEvent) {
            PlayerInteractEvent Eevent = (PlayerInteractEvent)event;
            Player player = Eevent.getPlayer();
            UUID id = player.getUniqueId();
            if (player.getItemInHand().getType() == this.materialToUse && Eevent.getAction() == Action.RIGHT_CLICK_AIR && !this.launchMap.values().contains(id) && !this.pulling.contains(id)) {
                return true;
            }
        }
        return event instanceof ProjectileHitEvent && this.launchMap.containsKey(projectile = ((ProjectileHitEvent)event).getEntity());
    }

    @Override
    public boolean isBindable() {
        return true;
    }

    @Override
    protected TraitResults bindCastIntern(RaCPlayer player) {
        EventWrapper event = EventWrapperFactory.buildFromEvent((Event)new PlayerInteractEvent(player.getPlayer(), null, null, null, null));
        return this.trigger(event);
    }
}

