/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.ExecuteTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.InstantMeleeDamageTrait.InstantMeleeDamageTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class ExecuteTrait
extends InstantMeleeDamageTrait {
    private double percent = 20.0;

    @Override
    @TraitInfos(category="activate", traitName="ExecuteTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public String getName() {
        return "ExecuteTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="percent", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.percent = configMap.getAsDouble("percent", 20.0);
    }

    @Override
    public TraitResults trigger(EventWrapper wrapper) {
        return TraitResults.False();
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "does instant " + this.damage + " damage when under " + this.percent + " percent";
    }

    @Override
    protected TraitRestriction checkForFurtherRestrictions(EventWrapper wrapper) {
        int range = this.modifyToPlayer(wrapper.getPlayer(), this.range, "range");
        Object target = SearchEntity.inLineOfSight(range, (LivingEntity)wrapper.getPlayer().getPlayer());
        if (target == null) {
            return TraitRestriction.NoTarget;
        }
        double targetPercent = target.getMaxHealth() / target.getHealth();
        if (targetPercent > this.percent) {
            return TraitRestriction.NoTarget;
        }
        if (EnemyChecker.areAllies((Entity)wrapper.getPlayer().getPlayer(), target)) {
            return TraitRestriction.TargetFriendly;
        }
        return null;
    }

    @Override
    protected TraitResults bindCastIntern(RaCPlayer player) {
        int range = this.modifyToPlayer(player, this.range, "range");
        Object target = SearchEntity.inLineOfSight(range, (LivingEntity)player.getPlayer());
        if (target == null) {
            return TraitResults.False();
        }
        double newDamage = this.modifyToPlayer(player, this.damage, "damage");
        CompatibilityModifier.LivingEntity.safeDamageEntityByEntity(target, (LivingEntity)player.getPlayer(), newDamage, this.damageType.getCause());
        Vollotile.get().sendOwnParticleEffectToAll(this.damageType.getParticleContainer(), target.getEyeLocation());
        return TraitResults.True();
    }

    @Override
    public boolean isBindable() {
        return true;
    }
}

