/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.BackstabTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractActivatableTrait;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Listener;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BackstabTrait
extends AbstractActivatableTrait
implements Listener {
    private int range = 0;
    private int strength = 0;
    private int duration = 0;

    @Override
    @TraitEventsUsed
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "BackstabTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "distance: " + this.range + " blocks.";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="range", classToExpect=Integer.class, optional=false), @TraitConfigurationField(fieldName="strength", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="duration", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.range = configMap.getAsInt("range");
        this.strength = configMap.getAsInt("strength", 0);
        this.duration = configMap.getAsInt("duration", 0);
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait lets you Poison your Weapon.");
        helpList.add(ChatColor.YELLOW + "Poison your weapon with a ROSE in the Workbench.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof BackstabTrait)) {
            return false;
        }
        BackstabTrait otherTrait = (BackstabTrait)trait;
        return this.range >= otherTrait.range;
    }

    @Override
    @TraitInfos(category="activate", traitName="BackstabTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        return false;
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper wrapper) {
        return false;
    }

    @Override
    public boolean notifyTriggeredUplinkTime(EventWrapper wrapper) {
        return true;
    }

    @Override
    public TraitResults trigger(RaCPlayer player) {
        Object target = SearchEntity.inLineOfSight(this.range, (LivingEntity)player.getPlayer());
        if (target == null) {
            return TraitResults.False();
        }
        Location targetLocation = target.getLocation().add(0.0, 0.3, 0.0);
        Location playerLocation = player.getLocation();
        if (targetLocation.getWorld() != playerLocation.getWorld()) {
            return TraitResults.False();
        }
        if (targetLocation.distance(playerLocation) > (double)this.range) {
            return TraitResults.False();
        }
        LanguageAPI.sendTranslatedMessage(player, "trait_backstab_success", "name", target.getType().name());
        targetLocation.subtract(targetLocation.getDirection());
        Location searchLocation = targetLocation.clone();
        if (searchLocation.add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR) {
            targetLocation = target.getLocation();
        }
        if ((searchLocation = targetLocation.clone()).add(0.0, 2.0, 0.0).getBlock().getType() != Material.AIR) {
            targetLocation = target.getLocation();
        }
        player.getPlayer().teleport(targetLocation);
        if (this.strength > 0 && this.duration > 0) {
            player.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, this.duration * 20, this.strength));
        }
        return TraitResults.True();
    }
}

