/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.AreaDamageTrait;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractActivateAETrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.damage.PreEntityDamageEvent;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.ParticleEffects;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AreaDamageTrait
extends AbstractActivateAETrait {
    protected double damage = 1.0;
    protected EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.FIRE;
    protected ParticleContainer particles = new ParticleContainer(ParticleEffects.FIREWORKS_SPARK, 30, 0.0f);
    protected ParticleContainer particlesFromSelf = null;
    protected boolean showLine = true;

    @Override
    public String getName() {
        return "AreaDamageTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="damage", classToExpect=Double.class, optional=false), @TraitConfigurationField(fieldName="cause", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="particle", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="particleFromSelf", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="showLine", classToExpect=Boolean.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("damage")) {
            this.damage = configMap.getAsDouble("damage");
        }
        if (configMap.containsKey("showLine")) {
            this.showLine = configMap.getAsBool("showLine");
        }
        if (configMap.containsKey("cause")) {
            String stringCause = configMap.getAsString("cause");
            EntityDamageEvent.DamageCause realCause = EntityDamageEvent.DamageCause.FIRE;
            try {
                realCause = EntityDamageEvent.DamageCause.valueOf((String)stringCause.toUpperCase());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cause = realCause;
        }
        if (configMap.containsKey("particle")) {
            this.particles = configMap.getAsParticleContainer("particle");
        }
        if (configMap.containsKey("particleFromSelf")) {
            this.particlesFromSelf = configMap.getAsParticleContainer("particleFromSelf");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This Trait Does an AOE and hits everyone in range.");
        return helpList;
    }

    @Override
    @TraitInfos(category="activate", traitName="AreaDamageTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
    }

    @Override
    protected boolean triggerOnEntity(final RaCPlayer player, final Entity otherEntity) {
        if (!(otherEntity instanceof LivingEntity)) {
            return false;
        }
        double modDamage = this.modifyToPlayer(player, this.damage, "damage");
        final double damage = PreEntityDamageEvent.getRealDamage((Entity)player.getPlayer(), otherEntity, EntityDamageEvent.DamageCause.CONTACT, modDamage);
        if (damage <= 0.0) {
            return false;
        }
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                CompatibilityModifier.LivingEntity.safeDamageEntityByEntity((LivingEntity)otherEntity, (LivingEntity)player.getPlayer(), damage);
            }
        };
        int later = 0;
        if (this.particles != null) {
            if (this.showLine) {
                int maxTimeToTake = 20;
                final Queue<Location> onTheWay = SearchEntity.getAllOnWay(player.getLocation(), otherEntity.getLocation());
                int ticks = maxTimeToTake / onTheWay.size();
                new BukkitRunnable(){

                    public void run() {
                        if (onTheWay.isEmpty()) {
                            this.cancel();
                            return;
                        }
                        Location next = (Location)onTheWay.poll();
                        Vollotile.get().sendOwnParticleEffectToAll(AreaDamageTrait.this.particles, next);
                    }
                }.runTaskTimer((Plugin)this.plugin, (long)ticks, (long)ticks);
                later = 20;
            } else {
                Vollotile.get().sendOwnParticleEffectToAll(this.particles, otherEntity.getLocation());
            }
        }
        runnable.runTaskLater((Plugin)this.plugin, (long)later);
        if (this.particlesFromSelf != null) {
            Vollotile.get().sendOwnParticleEffectToAll(this.particlesFromSelf, player.getLocation());
        }
        return true;
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Does " + this.damage + " damage on Enemies around you.";
    }
}

