/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.activate.AreaAirDropTrait;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.damage.PreEntityDamageEvent;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockIterator;

public class AreaAirDropTrait
extends AbstractMagicSpellTrait
implements Listener {
    protected double damage = 1.0;
    protected EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.FIRE;
    protected int rainRange = 10;
    protected int explosionRange = 2;
    protected int amount = 5;
    protected int aboveTarget = 15;
    protected Material mat = Material.TNT;
    protected int matDamageValue = 0;
    protected ParticleContainer particles = null;
    protected ParticleContainer particlesFromSelf = null;
    private final String DELETE_ON_DROP = "DELETE_ON_DROP";

    public AreaAirDropTrait() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RacesAndClasses.getPlugin());
    }

    @Override
    public String getName() {
        return "AreaAirDropTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="damage", classToExpect=Double.class, optional=false), @TraitConfigurationField(fieldName="cause", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="rainRange", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="explosionRange", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="amount", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="aboveTarget", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="material", classToExpect=Material.class, optional=true), @TraitConfigurationField(fieldName="materialDamageValue", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="particle", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="particleFromSelf", classToExpect=String.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("rainRange")) {
            this.rainRange = configMap.getAsInt("rainRange");
        }
        if (configMap.containsKey("explosionRange")) {
            this.explosionRange = configMap.getAsInt("explosionRange");
        }
        if (configMap.containsKey("amount")) {
            this.amount = configMap.getAsInt("amount");
        }
        if (configMap.containsKey("aboveTarget")) {
            this.aboveTarget = configMap.getAsInt("aboveTarget");
        }
        if (configMap.containsKey("material")) {
            this.mat = configMap.getAsMaterial("material");
            if (!this.mat.isBlock()) {
                this.mat = Material.GLOWSTONE;
            }
        }
        if (configMap.containsKey("materialDamageValue")) {
            this.matDamageValue = configMap.getAsInt("materialDamageValue");
        }
        if (configMap.containsKey("damage")) {
            this.damage = configMap.getAsDouble("damage");
        }
        if (configMap.containsKey("cause")) {
            String stringCause = configMap.getAsString("cause");
            EntityDamageEvent.DamageCause realCause = EntityDamageEvent.DamageCause.FIRE;
            try {
                realCause = EntityDamageEvent.DamageCause.valueOf((String)stringCause.toUpperCase());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cause = realCause;
        }
        if (configMap.containsKey("particle")) {
            this.particles = configMap.getAsParticleContainer("particle");
        }
        if (configMap.containsKey("particleFromSelf")) {
            this.particlesFromSelf = configMap.getAsParticleContainer("particleFromSelf");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This Trait Does an AOE and hits everyone in range.");
        return helpList;
    }

    @Override
    @TraitInfos(category="activate", traitName="AreaAirDropTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Does damage on Stuff around.";
    }

    private Location getLookLocation(RaCPlayer player) {
        BlockIterator blockIt = new BlockIterator((LivingEntity)player.getPlayer());
        int i = 0;
        Location backup = null;
        Block current = blockIt.next();
        while (blockIt.hasNext()) {
            current = blockIt.next();
            if (current.getType() != Material.AIR) {
                return current.getLocation();
            }
            if (++i == 10) {
                backup = current.getLocation();
            }
            if (i <= 200) continue;
            return backup;
        }
        return current.getLocation();
    }

    @EventHandler
    public void chunkUnload(ChunkUnloadEvent event) {
        for (Entity entity : Arrays.asList(event.getChunk().getEntities())) {
            if (!entity.hasMetadata("DELETE_ON_DROP")) continue;
            entity.remove();
        }
    }

    @EventHandler
    public void fallingBlockTransform(EntityChangeBlockEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity().hasMetadata("DELETE_ON_DROP")) {
            RaCPlayer player = (RaCPlayer)((MetadataValue)event.getEntity().getMetadata("DELETE_ON_DROP").get(0)).value();
            if (player == null || !player.getTraits().contains(this)) {
                return;
            }
            event.getEntity().remove();
            event.setCancelled(true);
            if (this.particles != null) {
                Vollotile.get().sendOwnParticleEffectToAll(this.particles, event.getBlock().getLocation());
            }
            List<Entity> around = SearchEntity.inCircleAround(event.getEntity(), this.explosionRange);
            for (Entity entity : around) {
                if (EnemyChecker.areAllies((Entity)player.getPlayer(), entity)) continue;
                this.explosionHitOnTarget(player, entity);
            }
        }
    }

    public void explosionHitOnTarget(RaCPlayer damager, Entity targetEntity) {
        if (!(targetEntity instanceof LivingEntity)) {
            return;
        }
        if (damager.getPlayer() == targetEntity) {
            return;
        }
        double modDamage = this.modifyToPlayer(damager, this.damage, "damage");
        LivingEntity target = (LivingEntity)targetEntity;
        double damage = PreEntityDamageEvent.getRealDamage((Entity)damager.getPlayer(), (Entity)target, EntityDamageEvent.DamageCause.CONTACT, modDamage);
        if (damage <= 0.0) {
            return;
        }
        target.setNoDamageTicks(0);
        CompatibilityModifier.LivingEntity.safeDamageEntityByEntity(target, (LivingEntity)damager.getPlayer(), damage);
        target.setNoDamageTicks(20);
        if (this.particles != null) {
            Vollotile.get().sendOwnParticleEffectToAll(this.particles, target.getEyeLocation());
        }
    }

    private List<Location> getRandomLocations(RaCPlayer player, Location loc) {
        LinkedList<Location> locs = new LinkedList<Location>();
        if (this.rainRange <= 0) {
            this.rainRange = 5;
        }
        Random rand = new Random();
        int i = 0;
        int modAmount = this.modifyToPlayer(player, this.amount, "amount");
        while (locs.size() < modAmount) {
            double xOffset = rand.nextDouble() * (double)this.rainRange * 2.0 - (double)this.rainRange;
            double zOffset = rand.nextDouble() * (double)this.rainRange * 2.0 - (double)this.rainRange;
            Location newLocation = loc.clone().add(xOffset, 0.0, zOffset);
            if (newLocation.distanceSquared(loc) <= (double)(this.rainRange * this.rainRange)) {
                locs.add(newLocation);
            }
            if (++i <= 200) continue;
            return locs;
        }
        return locs;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Location lookLocation = this.getLookLocation(player);
        Location middle = lookLocation.clone().add(0.0, (double)this.aboveTarget, 0.0);
        List<Location> spawnLocs = this.getRandomLocations(player, middle);
        for (Location loc : spawnLocs) {
            if (loc.getBlock().getType() != Material.AIR) continue;
            FallingBlock entity = loc.getWorld().spawnFallingBlock(loc, this.mat.getId(), (byte)this.matDamageValue);
            entity.setDropItem(false);
            entity.setMetadata("DELETE_ON_DROP", (MetadataValue)new FixedMetadataValue((Plugin)RacesAndClasses.getPlugin(), (Object)player));
        }
        if (this.particlesFromSelf != null) {
            Vollotile.get().sendOwnParticleEffectToAll(this.particlesFromSelf, player.getPlayer().getLocation());
        }
        result.copyFrom(TraitResults.True());
    }
}

