/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.arrows;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.arrow.ArrowManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.PlayerRaCScoreboardManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.CostType;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithCost;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractActivatableTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.List;
import java.util.concurrent.Callable;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.LazyMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class AbstractArrow
extends AbstractActivatableTrait
implements TraitWithCost {
    protected static final String BOUND_TO_BOW_PATH = "boundToBow";
    protected static final String INITIAL_DAMAGE_PATH = "initialDamage";
    protected static final String ARROW_PARTICLE_PATH_PATH = "arrowParticlePath";
    protected RacesAndClasses plugin = RacesAndClasses.getPlugin();
    protected int duration;
    protected double totalDamage;
    protected double initialDamage = -1.0;
    protected boolean boundToBow = true;
    protected double cost = 0.0;
    protected Material materialForCasting = Material.FEATHER;
    protected CostType costType = CostType.MANA;
    protected byte materialDamageForCasting = 0;
    protected String materialNameForCasting = null;
    protected ParticleContainer arrowPathParticles = null;
    private static final String ARROW_META_KEY = "arrowType";

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="boundToBow", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="initialDamage", classToExpect=double.class, optional=true), @TraitConfigurationField(fieldName="arrowParticlePath", classToExpect=ParticleContainer.class, optional=true), @TraitConfigurationField(fieldName="cost", classToExpect=Double.class, optional=true), @TraitConfigurationField(fieldName="costType", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="item", classToExpect=Material.class, optional=true), @TraitConfigurationField(fieldName="itemDamage", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="itemName", classToExpect=String.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.boundToBow = configMap.getAsBool(BOUND_TO_BOW_PATH, true);
        this.initialDamage = configMap.getAsDouble(INITIAL_DAMAGE_PATH, -1.0);
        this.arrowPathParticles = configMap.getAsParticleContainer(ARROW_PARTICLE_PATH_PATH, null);
        this.cost = configMap.getAsDouble("cost", 0.0);
        if (configMap.containsKey("costType")) {
            String costTypeName = configMap.getAsString("costType");
            this.costType = CostType.tryParse(costTypeName);
            if (this.costType == null) {
                throw new TraitConfigurationFailedException(String.valueOf(this.getName()) + " is incorrect configured. costType could not be read.");
            }
            if (this.costType == CostType.ITEM) {
                if (!configMap.containsKey("item")) {
                    throw new TraitConfigurationFailedException(String.valueOf(this.getName()) + " is incorrect configured. 'costType' was ITEM but no Item is specified at 'item'.");
                }
                this.materialForCasting = configMap.getAsMaterial("item");
                if (this.materialForCasting == null) {
                    throw new TraitConfigurationFailedException(String.valueOf(this.getName()) + " is incorrect configured." + " 'costType' was ITEM but the item read is not an Item. Items are CAPITAL. " + "See 'https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Material.html' for all Materials. " + "Alternative use an ItemID.");
                }
                this.materialDamageForCasting = (byte)configMap.getAsInt("itemDamage", 0);
                this.materialNameForCasting = configMap.getAsString("itemName", null);
            }
        }
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        Event event = wrapper.getEvent();
        if (!(event instanceof PlayerInteractEvent || event instanceof EntityShootBowEvent || event instanceof ProjectileHitEvent || event instanceof EntityDamageByEntityEvent)) {
            return false;
        }
        RaCPlayer player = wrapper.getPlayer();
        if (event instanceof PlayerInteractEvent) {
            PlayerInteractEvent Eevent = (PlayerInteractEvent)event;
            if (Eevent.getAction() != Action.LEFT_CLICK_AIR) {
                return false;
            }
            if (!this.isThisArrow(player)) {
                return false;
            }
            if (!TraitHolderCombinder.checkContainer(player, this)) {
                return false;
            }
            return player.getPlayer().getItemInHand().getType() == Material.BOW;
        }
        if (event instanceof EntityShootBowEvent) {
            EntityShootBowEvent Eevent = (EntityShootBowEvent)event;
            if (Eevent.getEntity().getType() != EntityType.PLAYER) {
                return false;
            }
            if (!TraitHolderCombinder.checkContainer(player, this)) {
                return false;
            }
            return this.isThisArrow(player);
        }
        if (event instanceof ProjectileHitEvent) {
            ProjectileHitEvent Eevent = (ProjectileHitEvent)event;
            if (Eevent.getEntityType() != EntityType.ARROW) {
                return false;
            }
            Projectile arrow = Eevent.getEntity();
            if (CompatibilityModifier.Shooter.getShooter(arrow) == null) {
                return false;
            }
            List metaValues = arrow.getMetadata(ARROW_META_KEY);
            if (arrow.getMetadata(ARROW_META_KEY).isEmpty()) {
                return false;
            }
            boolean found = false;
            for (MetadataValue value : metaValues) {
                if (!this.getDisplayName().equals(value.value())) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            this.removeMetadataNextTick(arrow);
            LivingEntity shooter = CompatibilityModifier.Shooter.getShooter(arrow);
            if (shooter.getType() != EntityType.PLAYER) {
                return false;
            }
            RaCPlayer realPlayer = RaCPlayerManager.get().getPlayer((Player)shooter);
            if (!TraitHolderCombinder.checkContainer(realPlayer, this)) {
                return false;
            }
            return this.isThisArrow(realPlayer);
        }
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent Eevent = (EntityDamageByEntityEvent)event;
            if (Eevent.getDamager().getType() != EntityType.ARROW) {
                return false;
            }
            Arrow realArrow = (Arrow)Eevent.getDamager();
            LivingEntity shooter = CompatibilityModifier.Shooter.getShooter((Projectile)realArrow);
            if (shooter == null || realArrow == null || realArrow.isDead()) {
                return false;
            }
            if (shooter.getType() != EntityType.PLAYER) {
                return false;
            }
            if (Eevent.getEntity() == shooter && realArrow.getTicksLived() < 5) {
                return false;
            }
            if (!TraitHolderCombinder.checkContainer(player, this)) {
                return false;
            }
            if (realArrow.getMetadata(ARROW_META_KEY).isEmpty()) {
                return false;
            }
            List metaValues = realArrow.getMetadata(ARROW_META_KEY);
            boolean found = false;
            for (MetadataValue value : metaValues) {
                if (!this.getDisplayName().equals(value.value())) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            realArrow.removeMetadata(ARROW_META_KEY, (Plugin)this.plugin);
            if (EnemyChecker.areAllies((Entity)realArrow, Eevent.getEntity())) {
                return false;
            }
            return this.isThisArrow(player);
        }
        return false;
    }

    private boolean isThisArrow(RaCPlayer player) {
        ArrowManager arrowManager = player.getArrowManager();
        AbstractArrow arrow = arrowManager.getCurrentArrow();
        return arrow != null && arrow == this;
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        TraitResults result = new TraitResults();
        if (event instanceof PlayerInteractEvent) {
            this.changeArrowType(eventWrapper.getPlayer());
            return result.setTriggered(false);
        }
        if (event instanceof EntityShootBowEvent) {
            EntityShootBowEvent Eevent = (EntityShootBowEvent)event;
            Arrow arrow = (Arrow)Eevent.getProjectile();
            arrow.setMetadata(ARROW_META_KEY, (MetadataValue)new LazyMetadataValue((Plugin)this.plugin, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return AbstractArrow.this.getDisplayName();
                }
            }));
            boolean triggered = this.onShoot(Eevent);
            if (triggered) {
                eventWrapper.getPlayer().getSpellManager().removeCost(this);
                this.addParticleTask(arrow);
            }
            return result.setTriggered(triggered).setSetCooldownOnPositiveTrigger(triggered).setRemoveCostsAfterTrigger(triggered);
        }
        if (event instanceof ProjectileHitEvent) {
            ProjectileHitEvent Eevent = (ProjectileHitEvent)event;
            boolean change = this.onHitLocation(Eevent);
            return result.setTriggered(change);
        }
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent Eevent = (EntityDamageByEntityEvent)event;
            boolean change = this.onHitEntity(Eevent);
            Eevent.getDamager().remove();
            double modInitDamage = this.modifyToPlayer(eventWrapper.getPlayer(), this.initialDamage, INITIAL_DAMAGE_PATH);
            if (modInitDamage > 0.0) {
                Eevent.setDamage(modInitDamage);
            }
            return result.setTriggered(change);
        }
        return result.setTriggered(false);
    }

    private void addParticleTask(final Arrow arrow) {
        if (arrow == null || this.arrowPathParticles == null) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (arrow.isDead() || !arrow.isValid() || arrow.getVelocity().lengthSquared() < 0.2) {
                    this.cancel();
                    return;
                }
                Vollotile.get().sendOwnParticleEffectToAll(AbstractArrow.this.arrowPathParticles, arrow.getLocation());
            }
        }.runTaskTimer((Plugin)this.plugin, 2L, 2L);
    }

    protected void changeArrowType(RaCPlayer player) {
        AbstractArrow newArrow;
        ArrowManager arrowManager = player.getArrowManager();
        AbstractArrow arrow = arrowManager.getCurrentArrow();
        if (arrow == null || arrow != this) {
            return;
        }
        boolean forward = !player.getPlayer().isSneaking();
        AbstractArrow abstractArrow = newArrow = forward ? arrowManager.nextArrow() : arrowManager.previousArrow();
        if (newArrow != null && newArrow != arrow) {
            if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_enable_permanent_scoreboard()) {
                player.getScoreboardManager().updateSelectAndShow(PlayerRaCScoreboardManager.SBCategory.Arrows);
            }
            LanguageAPI.sendTranslatedMessage(player, "arrow_change", "trait_name", newArrow.getDisplayName());
        }
    }

    protected abstract boolean onShoot(EntityShootBowEvent var1);

    protected abstract boolean onHitEntity(EntityDamageByEntityEvent var1);

    protected abstract boolean onHitLocation(ProjectileHitEvent var1);

    protected abstract String getArrowName();

    @Override
    public String getDisplayName() {
        String superDisplayName = super.getDisplayName();
        if (superDisplayName.equals(this.getName())) {
            return this.getArrowName();
        }
        return superDisplayName;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (trait.getClass() != this.getClass()) {
            return false;
        }
        return false;
    }

    @Override
    public TraitResults trigger(RaCPlayer player) {
        Player realPlayer = player.getPlayer();
        if (realPlayer == null || !realPlayer.isOnline()) {
            return TraitResults.False();
        }
        Arrow arrow = (Arrow)realPlayer.launchProjectile(Arrow.class);
        if (arrow != null) {
            ItemStack item = new ItemStack(Material.BOW);
            item.addEnchantment(Enchantment.ARROW_INFINITE, 1);
            player.getSpellManager().removeCost(this);
            this.onShoot(new EntityShootBowEvent((LivingEntity)realPlayer, item, (Projectile)arrow, 1.0f));
            return TraitResults.True();
        }
        return TraitResults.False();
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() == PlayerAction.INTERACT_BLOCK || wrapper.getPlayerAction() == PlayerAction.INTERACT_BLOCK) {
            this.changeArrowType(wrapper.getPlayer());
            return true;
        }
        if (wrapper.getEvent() instanceof ProjectileHitEvent) {
            if (this.canBeTriggered(wrapper)) {
                this.trigger(wrapper);
            }
            return true;
        }
        if (wrapper.getEvent() instanceof EntityDamageByEntityEvent) {
            if (this.canBeTriggered(wrapper)) {
                this.trigger(wrapper);
            }
            return true;
        }
        return wrapper.getPlayerAction() == PlayerAction.DO_DAMAGE;
    }

    @Override
    public boolean isStackable() {
        return false;
    }

    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class, PlayerInteractEvent.class, EntityShootBowEvent.class, ProjectileHitEvent.class})
    public void generalInit() {
    }

    @Override
    public boolean notifyTriggeredUplinkTime(EventWrapper wrapper) {
        if (wrapper.getPlayer().getArrowManager().getCurrentArrow() != this) {
            return false;
        }
        return super.notifyTriggeredUplinkTime(wrapper);
    }

    @Override
    public boolean isBindable() {
        return !this.boundToBow;
    }

    @Override
    public double getCost(RaCPlayer player) {
        int level = player.getLevelManager().getCurrentLevel();
        return this.skillConfig.getCastCostForLevel(level, this.modifyToPlayer(player, this.cost, "cost"));
    }

    @Override
    public CostType getCostType() {
        return this.costType;
    }

    @Override
    public Material getCastMaterialType(RaCPlayer player) {
        int level = player.getLevelManager().getCurrentLevel();
        return this.skillConfig.getCastMaterialForLevel(level, this.materialForCasting);
    }

    @Override
    public short getCastMaterialDamage(RaCPlayer player) {
        int level = player.getLevelManager().getCurrentLevel();
        return this.skillConfig.getCastMaterialDamageForLevel(level, this.materialDamageForCasting);
    }

    @Override
    public String getCastMaterialName(RaCPlayer player) {
        int level = player.getLevelManager().getCurrentLevel();
        return this.skillConfig.getCastMaterialNameForLevel(level, this.materialNameForCasting);
    }

    @Override
    public void triggerButDoesNotHaveEnoghCostType(EventWrapper wrapper) {
    }

    @Override
    public boolean needsCostCheck(EventWrapper wrapper) {
        return wrapper.getEvent() instanceof EntityShootBowEvent;
    }

    private void removeMetadataNextTick(final Projectile pro) {
        new DebugBukkitRunnable("ArrowMetaRemover"){

            @Override
            protected void runIntern() {
                try {
                    pro.removeMetadata(AbstractArrow.ARROW_META_KEY, (Plugin)AbstractArrow.this.plugin);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
    }
}

