/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traitgui;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.StaticTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TraitInventory
extends InventoryView {
    private final RaCPlayer player;
    private final Inventory traitInventory;

    public TraitInventory(RaCPlayer player) {
        this.player = player;
        Set<Trait> traits = TraitHolderCombinder.getAllTraitsOfPlayer(this.player);
        Iterator<Trait> it = traits.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof StaticTrait)) continue;
            it.remove();
        }
        int size = traits.size();
        if ((size = (size / 9 + 1) * 9) < 27) {
            size = 27;
        }
        this.traitInventory = Bukkit.createInventory((InventoryHolder)player.getPlayer(), (int)size, (String)("Traits of: " + this.player.getName()));
        this.fillInventory(traits);
    }

    private void fillInventory(Set<Trait> traits) {
        for (Trait trait : traits) {
            ItemStack traitStack = new ItemStack(Material.ANVIL);
            ItemMeta meta = traitStack.getItemMeta();
            LinkedList<String> lore = new LinkedList<String>();
            meta.setDisplayName(ChatColor.LIGHT_PURPLE + trait.getDisplayName());
            String traitConfig = trait.getPrettyConfiguration();
            String[] words = new String[]{"No", "ConfigTotal", "Present."};
            if (traitConfig != null) {
                words = traitConfig.split(" ");
            }
            lore.add("- Trait: " + trait.getName());
            String currentLine = "- " + words[0];
            int i = 1;
            while (i < words.length) {
                String currentWord = words[i];
                if (currentLine.length() + words.length + 1 > 31) {
                    lore.add(currentLine);
                    currentLine = currentWord;
                } else {
                    currentLine = String.valueOf(currentLine) + " " + currentWord;
                }
                ++i;
            }
            if (currentLine.length() > 0) {
                lore.add(currentLine);
            }
            meta.setLore(lore);
            traitStack.setItemMeta(meta);
            this.traitInventory.addItem(new ItemStack[]{traitStack});
        }
    }

    public Inventory getTopInventory() {
        return this.traitInventory;
    }

    public Inventory getBottomInventory() {
        return Bukkit.createInventory((InventoryHolder)this.player.getPlayer(), (int)36);
    }

    public HumanEntity getPlayer() {
        return this.player.getPlayer();
    }

    public InventoryType getType() {
        return InventoryType.CHEST;
    }
}

