/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.modifiers.specific;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.modifiers.AbstractModifier;
import de.tobiyas.racesandclasses.traitcontainer.modifiers.exceptions.ModifierConfigurationException;
import de.tobiyas.util.RaC.evaluations.EvalEvaluator;
import de.tobiyas.util.RaC.evaluations.parts.Calculation;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;

public class EvaluationModifiers
extends AbstractModifier {
    private Calculation calculation;

    private EvaluationModifiers(String evalString, String toModify) throws ModifierConfigurationException {
        super(0.0, toModify);
        try {
            this.calculation = EvalEvaluator.parse(evalString);
        }
        catch (Throwable exp) {
            throw new EvaluationNotParseableException("eval:" + evalString + ":0:" + toModify, "eval", evalString, 0.0, toModify, exp.getMessage());
        }
    }

    @Override
    public double apply(RaCPlayer player, double value, Trait trait) {
        if (this.calculation == null) {
            return value;
        }
        Map<String, Double> vars = this.generateVariables(player, trait);
        vars.put("old", value);
        return this.calculation.calculate(vars);
    }

    private Map<String, Double> generateVariables(RaCPlayer player, Trait trait) {
        HashMap<String, Double> variables = new HashMap<String, Double>();
        Location loc = player.getLocation();
        variables.put("mana", player.getCurrentMana());
        variables.put("maxmana", player.getMaxMana());
        variables.put("level", Double.valueOf(player.getCurrentLevel()));
        variables.put("health", player.getHealth());
        variables.put("maxhealth", player.getMaxHealth());
        variables.put("skilllevel", Double.valueOf(player.getSkillTreeManager().getLevel(trait)));
        variables.put("playery", loc.getY());
        return variables;
    }

    public static EvaluationModifiers generate(String descriptor, double modifier, String toModify) throws ModifierConfigurationException {
        return new EvaluationModifiers(descriptor, toModify);
    }

    public static class EvaluationNotParseableException
    extends ModifierConfigurationException {
        private static final long serialVersionUID = 5502663814233447085L;
        private final String text;

        public EvaluationNotParseableException(String total, String type, String descriptor, double value, String appliedOn, String text) {
            super(total, type, descriptor, value, appliedOn);
            this.text = text;
        }

        @Override
        protected String formatErrorMSG() {
            return "Could not parse Evaluation: " + this.descriptor + " Error: " + this.text;
        }
    }
}

