/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.modifiers.specific;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.modifiers.AbstractModifier;
import de.tobiyas.racesandclasses.traitcontainer.modifiers.exceptions.ModifierConfigurationException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.block.Biome;

public class BiomeModifier
extends AbstractModifier {
    protected final Set<Biome> biomes;

    public BiomeModifier(Set<Biome> biomes, double modifier, String toModify) {
        super(modifier, toModify);
        this.biomes = biomes;
    }

    @Override
    public boolean canBeApplied(String toModify, RaCPlayer player) {
        if (!super.canBeApplied(toModify, player)) {
            return false;
        }
        Location loc = player.getLocation();
        int x = loc.getBlockX();
        int z = loc.getBlockZ();
        return this.biomes.contains(player.getWorld().getBiome(x, z));
    }

    public static BiomeModifier generate(String descriptor, double modifier, String toModify) throws ModifierConfigurationException {
        String[] biomeSplit = descriptor.split(Pattern.quote(","));
        HashSet<Biome> biomes = new HashSet<Biome>();
        String[] stringArray = biomeSplit;
        int n = biomeSplit.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String biomeName = stringArray[n2];
                if (biomeName.equals("all")) {
                    biomes.addAll(Arrays.asList(Biome.values()));
                }
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)biomeName.toUpperCase());
                }
                catch (IllegalArgumentException exp) {
                    break block6;
                }
                if (biome != null) {
                    biomes.add(biome);
                }
            }
            ++n2;
        }
        if (biomes.isEmpty()) {
            throw new NoBiomesSelectedException("biome:" + descriptor + ":" + modifier + ":" + toModify, descriptor, modifier, toModify);
        }
        return new BiomeModifier(biomes, modifier, toModify);
    }

    public static class NoBiomesSelectedException
    extends ModifierConfigurationException {
        private static final long serialVersionUID = 2353232997031140761L;

        public NoBiomesSelectedException(String total, String descriptor, double value, String appliedOn) {
            super(total, "biome", descriptor, value, appliedOn);
        }

        @Override
        public String formatErrorMSG() {
            return "No biome could be parsed from: " + this.descriptor;
        }
    }
}

