/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.interfaces.skills;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.Material;

public class SkillLevelConfig {
    private final Map<Integer, SkillLevelContainer> levelContainers = new HashMap<Integer, SkillLevelContainer>();

    public SkillLevelConfig(List<String> toParse) {
        if (toParse != null) {
            this.parse(toParse);
        }
    }

    public SkillLevelConfig() {
        this(null);
    }

    public void parse(List<String> toParse) {
        this.levelContainers.clear();
        if (toParse == null || toParse.isEmpty()) {
            return;
        }
        for (String line : toParse) {
            SkillLevelContainer container = SkillLevelContainer.parse(line);
            if (container == null || this.levelContainers.containsKey(container.getLevel())) continue;
            this.levelContainers.put(container.getLevel(), container);
        }
    }

    public int getPointsForLevel(int level) {
        if (this.levelContainers.isEmpty()) {
            return 1;
        }
        SkillLevelContainer nearest = this.getNearest(level);
        return nearest == null ? 1 : nearest.getPoints();
    }

    public double getCastCostForLevel(int level, double defaultValue) {
        if (this.levelContainers.isEmpty()) {
            return defaultValue;
        }
        SkillLevelContainer nearest = this.getNearest(level);
        double cost = nearest == null ? defaultValue : nearest.getCastCost();
        return cost < 0.0 ? defaultValue : cost;
    }

    public Material getCastMaterialForLevel(int level, Material defaultValue) {
        if (this.levelContainers.isEmpty()) {
            return defaultValue;
        }
        SkillLevelContainer nearest = this.getNearest(level);
        Material mat = nearest == null ? Material.AIR : nearest.getCastMaterial();
        return mat == Material.AIR ? defaultValue : nearest.getCastMaterial();
    }

    public short getCastMaterialDamageForLevel(int level, short defaultValue) {
        if (this.levelContainers.isEmpty()) {
            return defaultValue;
        }
        SkillLevelContainer nearest = this.getNearest(level);
        short damage = nearest == null ? defaultValue : nearest.getCastMaterialDamage();
        return damage <= 0 ? defaultValue : damage;
    }

    public String getCastMaterialNameForLevel(int level, String defaultValue) {
        if (this.levelContainers.isEmpty()) {
            return defaultValue;
        }
        SkillLevelContainer nearest = this.getNearest(level);
        String name = nearest == null ? defaultValue : nearest.getCastMaterialName();
        return name.isEmpty() ? defaultValue : name;
    }

    public List<String> getTraitPreForLevel(int level) {
        if (this.levelContainers.isEmpty()) {
            return new LinkedList<String>();
        }
        SkillLevelContainer nearest = this.getNearest(level);
        return nearest == null ? new LinkedList() : nearest.getPreTraits();
    }

    public int getMinLevel(int level) {
        if (this.levelContainers.isEmpty()) {
            return 1;
        }
        SkillLevelContainer nearest = this.getNearest(level);
        return nearest == null ? 1 : nearest.getMinLevel();
    }

    private SkillLevelContainer getNearest(int level) {
        SkillLevelContainer container = null;
        for (SkillLevelContainer c : this.levelContainers.values()) {
            int oldLevel;
            int cLevel = c.getLevel();
            int n = oldLevel = container == null ? 0 : container.getLevel();
            if (cLevel <= oldLevel || cLevel > level) continue;
            container = c;
        }
        return container;
    }

    private static class SkillLevelContainer {
        private final int level;
        private final int points;
        private final int minLevel;
        private final List<String> preTraits = new LinkedList<String>();
        private final double castCost;
        private final Material castMaterial;
        private final short castMaterialDamage;
        private final String castMaterialName;

        public SkillLevelContainer(int level, int minLevel, int points, List<String> preTraits, double castCost, Material castMaterial, short castMaterialDamage, String castMaterialName) {
            this.level = level;
            this.minLevel = minLevel;
            this.points = points;
            this.preTraits.addAll(preTraits);
            this.castCost = castCost;
            this.castMaterial = castMaterial;
            this.castMaterialDamage = castMaterialDamage;
            this.castMaterialName = castMaterialName;
        }

        public int getLevel() {
            return this.level;
        }

        public int getPoints() {
            return this.points;
        }

        public List<String> getPreTraits() {
            return this.preTraits;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        public double getCastCost() {
            return this.castCost;
        }

        public Material getCastMaterial() {
            return this.castMaterial;
        }

        public short getCastMaterialDamage() {
            return this.castMaterialDamage;
        }

        public String getCastMaterialName() {
            return this.castMaterialName;
        }

        public static SkillLevelContainer parse(String line) {
            String[] split = line.split(Pattern.quote("#"));
            int skillLevel = 1;
            int minLevel = 1;
            int points = 1;
            LinkedList<String> preTraits = new LinkedList<String>();
            int castingCost = -1;
            Material castingMaterial = Material.AIR;
            short castingMaterialDamage = -1;
            String castingMaterialName = "";
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (part.contains(":")) {
                    String[] parts = part.split(":", 2);
                    String label = parts[0];
                    String config = parts[1];
                    if ("level".equalsIgnoreCase(label)) {
                        try {
                            skillLevel = Integer.parseInt(config);
                        }
                        catch (Throwable throwable) {}
                    } else if ("minlevel".equalsIgnoreCase(label)) {
                        try {
                            minLevel = Integer.parseInt(config);
                        }
                        catch (Throwable throwable) {}
                    } else if ("points".equalsIgnoreCase(label)) {
                        try {
                            points = Integer.parseInt(config);
                        }
                        catch (Throwable throwable) {}
                    } else if ("traits".equalsIgnoreCase(label)) {
                        try {
                            String[] preSplit;
                            String[] stringArray2 = preSplit = config.split(Pattern.quote(";"));
                            int n3 = preSplit.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String pre = stringArray2[n4];
                                preTraits.add(pre);
                                ++n4;
                            }
                        }
                        catch (Throwable throwable) {}
                    } else {
                        if ("castingCost".equalsIgnoreCase(label)) {
                            try {
                                castingCost = Integer.parseInt(config);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if ("castingMaterial".equalsIgnoreCase(label) && (castingMaterial = Material.matchMaterial((String)config)) == null) {
                            castingMaterial = Material.AIR;
                        }
                        if ("castingMaterialDamage".equalsIgnoreCase(label)) {
                            try {
                                castingMaterialDamage = Short.parseShort(config);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if ("castingMaterialName".equalsIgnoreCase(label)) {
                            castingMaterialName = config;
                        }
                    }
                }
                ++n2;
            }
            return new SkillLevelContainer(skillLevel, minLevel, points, preTraits, castingCost, castingMaterial, castingMaterialDamage, castingMaterialName);
        }
    }
}

