/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.interfaces;

import de.tobiyas.racesandclasses.APIs.CooldownApi;
import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.eventprocessing.events.traittrigger.PostTraitTriggerEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.traittrigger.PreTraitTriggerEvent;
import de.tobiyas.racesandclasses.listeners.generallisteners.PlayerLastDamageListener;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithRestrictions;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.skills.SkillLevelConfig;
import de.tobiyas.racesandclasses.traitcontainer.modifiers.ModifierFactory;
import de.tobiyas.racesandclasses.traitcontainer.modifiers.TraitSituationModifier;
import de.tobiyas.racesandclasses.traitcontainer.modifiers.exceptions.ModifierConfigurationException;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigParser;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.util.traitutil.TraitVisible;
import de.tobiyas.racesandclasses.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.items.ItemCheckTemplate;
import de.tobiyas.util.RaC.vollotile.VollotileCode;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractBasicTrait
implements Trait,
TraitWithRestrictions,
Listener {
    public static final String MODIFIERS_PATH = "modifiers";
    public static final String ON_USE_PARTICLES_PATH = "onUseParticles";
    public static final String REPLACES_OTHER_TRAITS_PATH = "replacesOtherTraits";
    public static final String GLOBAL_SKILL_TREE_NAME = "GLOBAL";
    protected static final RacesAndClasses plugin = RacesAndClasses.getPlugin();
    protected int minimumLevel = 1;
    protected int maximumLevel = 90000000;
    protected final Set<Biome> biomes = new HashSet<Biome>();
    protected final Set<Material> wearing = new HashSet<Material>();
    protected boolean onlyInWater = false;
    protected boolean onlyOnLand = false;
    protected boolean onlyInLava = false;
    protected boolean onlyOnSnow = false;
    protected boolean onlyInNight = false;
    protected boolean onlyOnDay = false;
    protected int cooldownTime = 0;
    protected String displayName;
    protected int aboveElevation = Integer.MIN_VALUE;
    protected int belowElevation = Integer.MAX_VALUE;
    protected boolean onlyInRain = false;
    protected int onlyAfterDamaged = -1;
    protected int onlyAfterNotDamaged = -1;
    protected long minUplinkShowTime = 3L;
    protected boolean disableCooldownNotice = false;
    protected final List<Material> onlyOnBlocks = new LinkedList<Material>();
    protected final List<Material> notOnBlocks = new LinkedList<Material>();
    protected boolean onlyWhileSneaking = false;
    protected boolean onlyWhileNotSneaking = false;
    protected String neededPermission = "";
    protected String traitDiscription = "";
    protected boolean visible = true;
    protected final Set<AbstractTraitHolder> holders = new HashSet<AbstractTraitHolder>();
    protected TraitConfiguration currentConfig;
    protected ParticleEffects onUseParticles = ParticleEffects.SPELL;
    protected final HashMap<String, Long> uplinkNotifyList = new HashMap();
    protected final Set<World> onlyInWorlds = new HashSet<World>();
    protected final Set<TraitSituationModifier> modifiers = new HashSet<TraitSituationModifier>();
    protected final SkillLevelConfig skillConfig = new SkillLevelConfig();
    protected int skillTreeMaxLevel = 1;
    protected boolean permanentSkill = true;
    protected ItemCheckTemplate mainHandTemplate = ItemCheckTemplate.TRUE();
    protected ItemCheckTemplate offHandTemplate = ItemCheckTemplate.TRUE();
    protected int skillTreeSlot = -1;
    protected List<String> excludeOtherTraits = new ArrayList<String>();
    protected List<String> replacesOtherTraits = new ArrayList<String>();
    protected String skillTreeName = "GLOBAL";
    protected ItemStack skillTreeSymbol = new ItemStack(Material.BOOK);

    @Override
    public void addTraitHolder(AbstractTraitHolder abstractTraitHolder) {
        this.holders.add(abstractTraitHolder);
    }

    @Override
    public Set<AbstractTraitHolder> getTraitHolders() {
        return this.holders;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="minLevel", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="maxLevel", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="biomes", classToExpect=List.class, optional=true), @TraitConfigurationField(fieldName="onlyOnBlock", classToExpect=List.class, optional=true), @TraitConfigurationField(fieldName="onlyInWater", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="onlyOnLand", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="onlyInLava", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="onlyOnSnow", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="onlyOnDay", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="onlyInNight", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="onlyInRain", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="onlyAfterDamaged", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="onlyAfterNotDamaged", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="onlyWhileSneaking", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="onlyWhileNotSneaking", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="cooldown", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="aboveElevation", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="belowElevation", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="displayName", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="description", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="neededPermission", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="minUplinkShow", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="disableCooldownNotice", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="modifiers", classToExpect=List.class, optional=true), @TraitConfigurationField(fieldName="onlyInWorlds", classToExpect=List.class, optional=true), @TraitConfigurationField(fieldName="onUseParticles", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="visible", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="replacesOtherTraits", classToExpect=List.class, optional=true), @TraitConfigurationField(fieldName="skillLevelsConfig", classToExpect=List.class, optional=true), @TraitConfigurationField(fieldName="skillLevelsPre", classToExpect=List.class, optional=true), @TraitConfigurationField(fieldName="permanentTrait", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="skillTreeSlot", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="skillTreeMaterial", classToExpect=Material.class, optional=true), @TraitConfigurationField(fieldName="skillTreeDamage", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="skillTreeMaxLevel", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="skillTreeExcludeOthers", classToExpect=List.class, optional=true), @TraitConfigurationField(fieldName="skillTreeName", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="mainhand", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="offhand", classToExpect=String.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        this.currentConfig = configMap;
        this.visible = configMap.getAsBool("visible", true);
        if (!TraitVisible.isVisible(this)) {
            this.visible = false;
        }
        this.neededPermission = configMap.getAsString("neededPermission", "");
        this.cooldownTime = configMap.getAsInt("cooldown", 0);
        this.traitDiscription = configMap.getAsString("description", "");
        this.minimumLevel = configMap.getAsInt("minLevel", -1);
        this.maximumLevel = configMap.getAsInt("maxLevel", 90000000);
        this.onUseParticles = configMap.getAsParticle("onUseParticles", ParticleEffects.SPELL);
        this.onlyAfterDamaged = configMap.getAsInt("onlyAfterDamaged", -1);
        this.onlyAfterNotDamaged = configMap.getAsInt("onlyAfterNotDamaged", -1);
        this.aboveElevation = configMap.getAsInt("aboveElevation", -2147483648);
        this.belowElevation = configMap.getAsInt("belowElevation", 0x7FFFFFFF);
        this.skillTreeSlot = configMap.getAsInt("skillTreeSlot", -1);
        this.skillTreeMaxLevel = configMap.getAsInt("skillTreeMaxLevel", 1);
        if (configMap.containsKey("skillLevelsPre")) {
            this.skillConfig.parse(configMap.getAsStringList("skillLevelsPre"));
        } else {
            this.skillConfig.parse(configMap.getAsStringList("skillLevelsConfig"));
        }
        this.permanentSkill = configMap.getAsBool("permanentTrait", true);
        this.onlyInWater = configMap.getAsBool("onlyInWater", false);
        this.onlyInLava = configMap.getAsBool("onlyInLava", false);
        this.onlyInRain = configMap.getAsBool("onlyInRain", false);
        this.onlyOnSnow = configMap.getAsBool("onlyOnSnow", false);
        this.onlyOnLand = configMap.getAsBool("onlyOnLand", false);
        this.onlyOnDay = configMap.getAsBool("onlyOnDay", false);
        this.onlyInNight = configMap.getAsBool("onlyInNight", false);
        this.displayName = configMap.getAsString("displayName", null);
        this.onlyWhileSneaking = configMap.getAsBool("onlyWhileSneaking", false);
        this.onlyWhileNotSneaking = configMap.getAsBool("onlyWhileNotSneaking", false);
        this.minUplinkShowTime = configMap.getAsInt("minUplinkShow", 3);
        this.disableCooldownNotice = configMap.getAsBool("disableCooldownNotice", false);
        skillTreeMat = configMap.getAsMaterial("skillTreeMaterial", Material.BOOK);
        skillTreeDamage = (short)configMap.getAsInt("skillTreeDamage", 0);
        this.skillTreeName = configMap.getAsString("skillTreeName", "GLOBAL");
        this.skillTreeSymbol = new ItemStack(skillTreeMat, 1, skillTreeDamage);
        this.replacesOtherTraits.clear();
        this.replacesOtherTraits.addAll(configMap.getAsStringList("replacesOtherTraits"));
        this.excludeOtherTraits.clear();
        this.excludeOtherTraits.addAll(configMap.getAsStringList("skillTreeExcludeOthers"));
        if (configMap.containsKey("biomes")) {
            try {
                stringBiomes = configMap.getAsStringList("biomes");
                this.biomes.clear();
                for (String biome : stringBiomes) {
                    biome = biome.toUpperCase();
                    try {
                        biom = Biome.valueOf((String)biome);
                        if (biome == null) continue;
                        this.biomes.add(biom);
                    }
                    catch (Throwable biom) {
                        // empty catch block
                    }
                }
            }
            catch (Exception stringBiomes) {
                // empty catch block
            }
        }
        if (configMap.containsKey("onlyOnBlock")) {
            try {
                stringBlocks = (List)configMap.get("onlyOnBlock");
                this.onlyOnBlocks.clear();
                for (String block : stringBlocks) {
                    block = block.toUpperCase();
                    type = null;
                    try {
                        type = Material.valueOf((String)block);
                    }
                    catch (IllegalArgumentException var8_14) {
                        // empty catch block
                    }
                    if (type == null) {
                        try {
                            id = Integer.parseInt(block);
                            type = Material.getMaterial((int)id);
                        }
                        catch (NumberFormatException id) {
                            // empty catch block
                        }
                    }
                    if (type == null) continue;
                    this.onlyOnBlocks.add(type);
                }
            }
            catch (Exception stringBlocks) {
                // empty catch block
            }
        }
        if (configMap.containsKey("notOnBlock")) {
            try {
                stringBlocks = (List)configMap.get("notOnBlock");
                this.notOnBlocks.clear();
                for (String block : stringBlocks) {
                    block = block.toUpperCase();
                    type = null;
                    try {
                        type = Material.valueOf((String)block);
                    }
                    catch (IllegalArgumentException id) {
                        // empty catch block
                    }
                    if (type == null) {
                        try {
                            id = Integer.parseInt(block);
                            type = Material.getMaterial((int)id);
                        }
                        catch (NumberFormatException id) {
                            // empty catch block
                        }
                    }
                    if (type == null) continue;
                    this.notOnBlocks.add(type);
                }
            }
            catch (Exception stringBlocks) {
                // empty catch block
            }
        }
        if (configMap.containsKey("wearing")) {
            try {
                stringBlocks = (List)configMap.get("wearing");
                this.wearing.clear();
                for (String armor : stringBlocks) {
                    type = Material.valueOf((String)(armor = armor.toUpperCase()));
                    if (type == null) continue;
                    this.wearing.add(type);
                }
            }
            catch (Exception stringBlocks) {
                // empty catch block
            }
        }
        if (configMap.containsKey("modifiers") && !(mods = configMap.getAsStringList("modifiers")).isEmpty()) {
            for (String toParse : mods) {
                block42: {
                    try {
                        mod = ModifierFactory.generate(toParse);
                        if (mod == null) {
                            throw new Exception();
                        }
                        this.modifiers.add(mod);
                        continue;
                    }
                    catch (Exception e) {
                        if (!(e instanceof ModifierConfigurationException)) break block42;
                        exp = (ModifierConfigurationException)e;
                        holders = "";
                        ** for (holder : this.getTraitHolders())
                    }
lbl-1000:
                    // 1 sources

                    {
                        holders = String.valueOf(holders) + " " + holder.getDisplayName();
                        continue;
                    }
lbl143:
                    // 1 sources

                    AbstractBasicTrait.plugin.logWarning(exp.formatToText(holders, this.getDisplayName()));
                    continue;
                }
                holders = "";
                for (AbstractTraitHolder holder : this.getTraitHolders()) {
                    holders = String.valueOf(holders) + " " + holder.getDisplayName();
                }
                message = "Modifier: '" + toParse + "' of Trait: '" + this.getDisplayName() + "' from Holders: '" + holders + "' could not be parsed!";
                AbstractBasicTrait.plugin.logWarning(message);
            }
        }
        if (configMap.containsKey("onlyInWorlds")) {
            this.onlyInWorlds.clear();
            for (String worldName : configMap.getAsStringList("onlyInWorlds")) {
                world = Bukkit.getWorld((String)worldName);
                if (world == null) continue;
                this.onlyInWorlds.add(world);
            }
        }
        if (configMap.containsKey("mainhand")) {
            this.mainHandTemplate = ItemCheckTemplate.generate(configMap.getAsString("mainhand", ""));
        }
        if (configMap.containsKey("offhand")) {
            this.offHandTemplate = ItemCheckTemplate.generate(configMap.getAsString("offhand", ""));
        }
    }

    protected double modifyToPlayer(RaCPlayer player, double value, String toModify) {
        if (player == null) {
            return value;
        }
        if (this.modifiers.isEmpty()) {
            return value;
        }
        for (TraitSituationModifier mod : this.modifiers) {
            if (!mod.canBeApplied(toModify, player)) continue;
            value = mod.apply(player, value, (Trait)this);
        }
        return value;
    }

    protected int modifyToPlayer(RaCPlayer player, int value, String toModify) {
        if (player == null) {
            return value;
        }
        if (this.modifiers.isEmpty()) {
            return value;
        }
        for (TraitSituationModifier mod : this.modifiers) {
            if (!mod.canBeApplied(toModify, player)) continue;
            value = mod.apply(player, value, (Trait)this);
        }
        return value;
    }

    protected double getModValue(RaCPlayer player, String toModify) {
        return this.getModValue(player, toModify, 1.0);
    }

    protected double getModValue(RaCPlayer player, String toModify, double defaultValue) {
        if (player == null) {
            return defaultValue;
        }
        if (this.modifiers.isEmpty()) {
            return defaultValue;
        }
        double value = defaultValue;
        for (TraitSituationModifier mod : this.modifiers) {
            if (!mod.canBeApplied(toModify, player)) continue;
            value = mod.apply(player, value, (Trait)this);
        }
        return value;
    }

    @Override
    public TraitConfiguration getCurrentconfig() {
        return this.currentConfig;
    }

    @Override
    public void deInit() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public final List<String> getOptionalConfigFields() {
        List<TraitConfigurationField> configFields = TraitConfigParser.getAllTraitConfigFieldsOfTrait(this);
        LinkedList<String> optionalFields = new LinkedList<String>();
        for (TraitConfigurationField field : configFields) {
            if (!field.optional()) continue;
            optionalFields.add(field.fieldName());
        }
        return optionalFields;
    }

    @Override
    public final String getPrettyConfiguration() {
        if ("".equals(this.traitDiscription)) {
            return this.getPrettyConfigIntern();
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.traitDiscription);
    }

    protected abstract String getPrettyConfigIntern();

    @Override
    public TraitRestriction checkRestrictions(EventWrapper wrapper) {
        TraitRestriction furtherRestriction;
        String cooldownName;
        int playerUplinkTime;
        int lastDamage;
        ItemStack offhand;
        ItemStack mainHand;
        Biome currentBiome;
        RaCPlayer player = wrapper.getPlayer();
        if (player == null) {
            return TraitRestriction.Unknown;
        }
        if (!player.isOnline()) {
            return TraitRestriction.Unknown;
        }
        Player bPlayer = player.getPlayer();
        String playerName = player.getName();
        int playerLevel = player.getLevelManager().getCurrentLevel();
        if (playerLevel < this.minimumLevel) {
            return TraitRestriction.MinimumLevel;
        }
        if (playerLevel > this.maximumLevel) {
            return TraitRestriction.MaximumLevel;
        }
        if (!this.permanentSkill && plugin.getConfigManager().getGeneralConfig().isConfig_useSkillSystem() && player.getSkillTreeManager().getLevel(this) <= 0) {
            return TraitRestriction.NotSkilled;
        }
        Location playerLocation = player.getPlayer().getLocation();
        boolean isOutOfWorld = playerLocation.getY() < 0.0 || playerLocation.getY() > 256.0;
        Block feetBlock = isOutOfWorld ? null : playerLocation.getBlock();
        Block locBlock = isOutOfWorld ? null : feetBlock.getRelative(BlockFace.DOWN);
        Material feetType = feetBlock == null ? Material.AIR : feetBlock.getType();
        Material belowFeetType = locBlock == null ? Material.AIR : locBlock.getType();
        Biome biome = currentBiome = locBlock == null ? Biome.SKY : locBlock.getBiome();
        if (!this.biomes.isEmpty() && !this.biomes.contains(currentBiome)) {
            return TraitRestriction.Biomes;
        }
        if (!this.onlyInWorlds.isEmpty() && !this.onlyInWorlds.contains(player.getWorld())) {
            this.triggerButHasRestriction(TraitRestriction.OnlyInWorld, wrapper);
            return TraitRestriction.OnlyInWorld;
        }
        if (!isOutOfWorld && this.onlyInWater && feetType != Material.WATER && feetType != Material.STATIONARY_WATER) {
            this.triggerButHasRestriction(TraitRestriction.OnlyInWater, wrapper);
            return TraitRestriction.OnlyInWater;
        }
        if (this.onlyWhileSneaking && !player.getPlayer().isSneaking()) {
            this.triggerButHasRestriction(TraitRestriction.OnlyWhileSneaking, wrapper);
            return TraitRestriction.OnlyWhileSneaking;
        }
        if (this.onlyWhileNotSneaking && player.getPlayer().isSneaking()) {
            this.triggerButHasRestriction(TraitRestriction.OnlyWhileNotSneaking, wrapper);
            return TraitRestriction.OnlyWhileNotSneaking;
        }
        if (!isOutOfWorld && this.onlyOnLand && (feetType == Material.WATER || feetType == Material.STATIONARY_WATER)) {
            this.triggerButHasRestriction(TraitRestriction.OnlyOnLand, wrapper);
            return TraitRestriction.OnlyOnLand;
        }
        if (!this.neededPermission.isEmpty() && !plugin.getPermissionManager().checkPermissionsSilent((CommandSender)wrapper.getPlayer().getPlayer(), this.neededPermission)) {
            this.triggerButHasRestriction(TraitRestriction.NeededPermission, wrapper);
            return TraitRestriction.NeededPermission;
        }
        if (!isOutOfWorld && this.onlyInLava && feetType != Material.LAVA && feetType != Material.STATIONARY_LAVA) {
            this.triggerButHasRestriction(TraitRestriction.OnlyInLava, wrapper);
            return TraitRestriction.OnlyInLava;
        }
        if (!isOutOfWorld && this.onlyOnSnow && feetType != Material.SNOW && feetType != Material.SNOW_BLOCK && belowFeetType != Material.SNOW && belowFeetType != Material.SNOW_BLOCK) {
            this.triggerButHasRestriction(TraitRestriction.OnlyOnSnow, wrapper);
            return TraitRestriction.OnlyOnSnow;
        }
        if (!isOutOfWorld && this.onlyInRain) {
            int highestY;
            if (!wrapper.getWorld().hasStorm()) {
                return TraitRestriction.OnlyInRain;
            }
            int ownY = feetBlock.getY();
            if (ownY != (highestY = feetBlock.getWorld().getHighestBlockYAt(feetBlock.getX(), feetBlock.getZ()))) {
                this.triggerButHasRestriction(TraitRestriction.OnlyInRain, wrapper);
                return TraitRestriction.OnlyInRain;
            }
        }
        if (!this.wearing.isEmpty()) {
            boolean found = false;
            for (Material mat : this.wearing) {
                found = false;
                ItemStack[] itemStackArray = player.getPlayer().getInventory().getArmorContents();
                int n = itemStackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemStack item = itemStackArray[n2];
                    if (item != null && mat == item.getType()) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (found) continue;
                this.triggerButHasRestriction(TraitRestriction.Wearing, wrapper);
                return TraitRestriction.Wearing;
            }
        }
        if (!this.mainHandTemplate.appliable(mainHand = bPlayer.getInventory().getItem(bPlayer.getInventory().getHeldItemSlot()))) {
            this.triggerButHasRestriction(TraitRestriction.MainHandItem, wrapper);
            return TraitRestriction.MainHandItem;
        }
        if (VollotileCodeManager.getVollotileCode().getVersion().isVersionGreaterOrEqual(VollotileCode.MCVersion.v1_9_R1) && !this.offHandTemplate.appliable(offhand = player.getPlayer().getInventory().getItemInOffHand())) {
            this.triggerButHasRestriction(TraitRestriction.OffHandItem, wrapper);
            return TraitRestriction.OffHandItem;
        }
        if (!isOutOfWorld && this.aboveElevation != Integer.MIN_VALUE && feetBlock.getY() <= this.aboveElevation) {
            this.triggerButHasRestriction(TraitRestriction.AboveLevitation, wrapper);
            return TraitRestriction.AboveLevitation;
        }
        if (!isOutOfWorld && this.belowElevation != Integer.MAX_VALUE && feetBlock.getY() >= this.belowElevation) {
            this.triggerButHasRestriction(TraitRestriction.BelowLevitation, wrapper);
            return TraitRestriction.BelowLevitation;
        }
        if (this.onlyAfterDamaged > 0 && (lastDamage = PlayerLastDamageListener.getTimePassedSinceLastDamageInSeconds(playerName)) > this.onlyAfterDamaged) {
            this.triggerButHasRestriction(TraitRestriction.OnlyAfterDamage, wrapper);
            return TraitRestriction.OnlyAfterDamage;
        }
        if (this.onlyAfterNotDamaged > 0 && this.onlyAfterNotDamaged > (lastDamage = PlayerLastDamageListener.getTimePassedSinceLastDamageInSeconds(playerName))) {
            this.triggerButHasRestriction(TraitRestriction.OnlyAfterNotDamage, wrapper);
            return TraitRestriction.OnlyAfterNotDamage;
        }
        if (!(isOutOfWorld || this.onlyOnBlocks.isEmpty() || this.onlyOnBlocks.contains(belowFeetType))) {
            this.triggerButHasRestriction(TraitRestriction.OnlyOnBlock, wrapper);
            return TraitRestriction.OnlyOnBlock;
        }
        if (!isOutOfWorld && !this.notOnBlocks.isEmpty() && this.notOnBlocks.contains(belowFeetType)) {
            this.triggerButHasRestriction(TraitRestriction.NotOnBlock, wrapper);
            return TraitRestriction.NotOnBlock;
        }
        if (this.cooldownTime > 0 && (playerUplinkTime = CooldownApi.getCooldownOfPlayer(playerName, cooldownName = this.getCooldownName())) > 0) {
            if (!this.triggerButHasUplink(wrapper)) {
                this.triggerButHasRestriction(TraitRestriction.Cooldown, wrapper);
                if (this.notifyTriggeredUplinkTime(wrapper)) {
                    long maxTime;
                    if (this.disableCooldownNotice) {
                        return TraitRestriction.Cooldown;
                    }
                    long lastNotified = this.uplinkNotifyList.containsKey(playerName) ? this.uplinkNotifyList.get(playerName) : 0L;
                    if (new Date().after(new Date(lastNotified + (maxTime = this.minUplinkShowTime * 1000L)))) {
                        LanguageAPI.sendTranslatedMessage((CommandSender)player.getPlayer(), "trait_cooldown", "seconds", String.valueOf(playerUplinkTime), "name", this.getDisplayName());
                        this.uplinkNotifyList.put(playerName, new Date().getTime());
                    }
                }
            }
            return TraitRestriction.Cooldown;
        }
        if (this.onlyOnDay || this.onlyInNight) {
            boolean isDay;
            int hour = ((int)(wrapper.getWorld().getTime() / 1000L) + 6) % 24;
            boolean isNight = hour > 18 || hour < 6;
            boolean bl = isDay = hour > 6 && hour < 18;
            if (this.onlyOnDay && isNight && !this.onlyInNight) {
                this.triggerButHasRestriction(TraitRestriction.OnlyOnDay, wrapper);
                return TraitRestriction.OnlyOnDay;
            }
            if (this.onlyInNight && isDay && !this.onlyOnDay) {
                this.triggerButHasRestriction(TraitRestriction.OnlyInNight, wrapper);
                return TraitRestriction.OnlyOnDay;
            }
        }
        if ((furtherRestriction = this.checkForFurtherRestrictions(wrapper)) != null && furtherRestriction != TraitRestriction.None) {
            this.triggerButHasRestriction(furtherRestriction, wrapper);
            return furtherRestriction;
        }
        PreTraitTriggerEvent event = new PreTraitTriggerEvent(player.getPlayer(), this, player.getWorld());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event.getRestriction();
        }
        return TraitRestriction.None;
    }

    protected TraitRestriction checkForFurtherRestrictions(EventWrapper wrapper) {
        return null;
    }

    @Override
    public boolean isStackable() {
        return true;
    }

    @Override
    public int getMaxUplinkTime() {
        return this.cooldownTime;
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper wrapper) {
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public boolean notifyTriggeredUplinkTime(EventWrapper wrapper) {
        return true;
    }

    @Override
    public String getDisplayName() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(this.displayName == null ? this.getName() : this.displayName));
    }

    @Override
    public boolean isInLevelRange(int level) {
        if (level < this.minimumLevel) {
            return false;
        }
        return level <= this.maximumLevel;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void triggerButHasRestriction(TraitRestriction restriction, EventWrapper wrapper) {
    }

    @Override
    public boolean isBindable() {
        return false;
    }

    @Override
    public String getCooldownName() {
        return "trait." + this.getDisplayName();
    }

    @Override
    public int getMaxLevel() {
        return this.maximumLevel;
    }

    @Override
    public int getMinLevel() {
        return this.minimumLevel;
    }

    @Override
    public final TraitResults triggerOnBind(RaCPlayer using) {
        if (!this.isBindable()) {
            return TraitResults.False();
        }
        if (!using.isOnline()) {
            return TraitResults.False();
        }
        EventWrapper wrapper = EventWrapperFactory.buildOnlyWithplayer(using);
        if (this.checkRestrictions(wrapper) != TraitRestriction.None) {
            return TraitResults.False();
        }
        TraitResults result = this.bindCastIntern(using);
        if (result.isTriggered()) {
            PostTraitTriggerEvent event = new PostTraitTriggerEvent(wrapper, this);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        return result;
    }

    protected TraitResults bindCastIntern(RaCPlayer player) {
        return TraitResults.False();
    }

    public boolean hasPlayer(RaCPlayer player) {
        return TraitHolderCombinder.checkContainer(player, this);
    }

    @Override
    public int compareTo(Trait other) {
        return this.getDisplayName().compareTo(other.getDisplayName());
    }

    @Override
    public int getSkillPointCost(int level) {
        return this.skillConfig.getPointsForLevel(level);
    }

    @Override
    public int getSkillMinLevel(int level) {
        return this.skillConfig.getMinLevel(level);
    }

    @Override
    public String getSkillTreeName() {
        return this.skillTreeName;
    }

    @Override
    public boolean isPermanentSkill() {
        return this.permanentSkill;
    }

    @Override
    public int getSkillTreePlace() {
        return this.skillTreeSlot;
    }

    @Override
    public ItemStack getSkillTreeSymbol() {
        return this.skillTreeSymbol.clone();
    }

    @Override
    public int getSkillMaxLevel() {
        return this.skillTreeMaxLevel;
    }

    @Override
    public List<String> getSkillTreePrequisits(int level) {
        return this.skillConfig.getTraitPreForLevel(level);
    }

    @Override
    public List<String> getExcludesOtherTraits() {
        return this.excludeOtherTraits;
    }

    @Override
    public List<String> getReplacesOtherTraits() {
        return this.replacesOtherTraits;
    }

    @Override
    public void skillLevelChanged(RaCPlayer player) {
    }
}

