/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.eventprocessing.TraitEventManager;
import de.tobiyas.racesandclasses.traitcontainer.container.TraitsList;
import de.tobiyas.racesandclasses.traitcontainer.exceptions.TraitNotFoundException;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.NeedMC1_6;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.NeedMC1_7;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.NeedMC1_8;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.NeedsOtherPlugins;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.CertainVersionChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.io.File;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class TraitStore {
    private static Set<ClassLoader> classLoaders = new HashSet<ClassLoader>();

    public static void destroyClassLoaders() {
        for (ClassLoader loader : classLoaders) {
            loader.clearAssertionStatus();
        }
        classLoaders.clear();
    }

    public static Trait buildTraitByName(String traitName, AbstractTraitHolder holder) {
        if (traitName == null || holder == null) {
            return null;
        }
        try {
            Trait trait = TraitStore.buildTrait(traitName, holder);
            TraitStore.registerTrait(trait);
            return trait;
        }
        catch (TraitNotFoundException e) {
            RacesAndClasses.getPlugin().log("Trait not found: " + e.getLocalizedMessage());
        }
        catch (AnnotationFormatError e) {
            RacesAndClasses.getPlugin().log("Could not find Annotation for: " + traitName + " Error was: " + e.getLocalizedMessage());
        }
        catch (TraitConfigurationFailedException exp) {
            RacesAndClasses.getPlugin().log("Coild not Construct trait: " + traitName + ". Problem was: " + exp.getLocalizedMessage());
        }
        catch (Exception e) {
            RacesAndClasses.getPlugin().log("Could not Construct trait: " + traitName);
            RacesAndClasses.getPlugin().getDebugLogger().logStackTrace(e);
        }
        return null;
    }

    private static Trait buildTrait(String traitName, AbstractTraitHolder holder) throws Exception {
        Class<? extends Trait> clazz = TraitsList.getClassOfTrait(traitName);
        if (clazz == null) {
            throw new TraitNotFoundException(traitName);
        }
        Trait trait = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (trait == null) {
            throw new TraitNotFoundException(traitName);
        }
        trait.addTraitHolder(holder);
        return trait;
    }

    private static boolean registerTrait(Trait trait) throws AnnotationFormatError {
        try {
            HashSet<Class<? extends Event>> wantedEvents = new HashSet<Class<? extends Event>>();
            int traitPriority = -1;
            Class<?> toInspect = trait.getClass();
            while (toInspect != null && toInspect != Object.class) {
                try {
                    try {
                        Method method = toInspect.getMethod("generalInit", new Class[0]);
                        TraitEventsUsed annotation = method.getAnnotation(TraitEventsUsed.class);
                        if (annotation != null) {
                            if (annotation.traitPriority() > traitPriority) {
                                traitPriority = annotation.traitPriority();
                            }
                            Collections.addAll(wantedEvents, annotation.registerdClasses());
                            Collections.addAll(wantedEvents, annotation.bypassClasses());
                        }
                    }
                    catch (Exception exp) {
                        toInspect = toInspect.getSuperclass();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    toInspect = toInspect.getSuperclass();
                    throw throwable;
                }
                toInspect = toInspect.getSuperclass();
            }
            if (!wantedEvents.isEmpty()) {
                TraitEventManager.registerTrait(trait, wantedEvents, traitPriority);
            }
            return true;
        }
        catch (AnnotationFormatError e) {
            throw e;
        }
        catch (Exception e) {
            RacesAndClasses.getPlugin().getDebugLogger().logStackTrace(e);
            return false;
        }
    }

    public static void importFromFileSystem() {
        RacesAndClasses plugin = RacesAndClasses.getPlugin();
        File traitDir = new File(plugin.getDataFolder() + File.separator + "ExternalTraits" + File.separator);
        if (!traitDir.exists()) {
            traitDir.mkdirs();
            return;
        }
        List<File> possibleTraits = TraitStore.getAllTraitsOfDir(traitDir);
        for (File file : possibleTraits) {
            try {
                TraitStore.loadExternalTrait(file);
            }
            catch (Throwable exception) {
                RacesAndClasses.getPlugin().log("Could not load file: " + file.toString());
            }
        }
    }

    private static List<File> getAllTraitsOfDir(File dir) {
        LinkedList<File> traitFileList = new LinkedList<File>();
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                traitFileList.addAll(TraitStore.getAllTraitsOfDir(file));
            } else if (file.getAbsolutePath().endsWith(".jar")) {
                traitFileList.add(file);
            }
            ++n2;
        }
        return traitFileList;
    }

    private static void loadExternalTrait(File file) {
        try {
            URLClassLoader clazzLoader = URLClassLoader.newInstance(new URL[]{file.toURI().toURL()}, ((Object)((Object)RacesAndClasses.getPlugin())).getClass().getClassLoader());
            classLoaders.add(clazzLoader);
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            HashSet clazzArray = new HashSet();
            while (entries.hasMoreElements()) {
                JarEntry element = entries.nextElement();
                if (!element.getName().endsWith(".class")) continue;
                try {
                    Class<?> clazz = clazzLoader.loadClass(element.getName().replaceAll(".class", "").replaceAll("/", "."));
                    if (clazz == null || !Trait.class.isAssignableFrom(clazz) || clazz.isAnnotationPresent(NeedMC1_6.class) && !CertainVersionChecker.isAbove1_6() || clazz.isAnnotationPresent(NeedMC1_7.class) && !CertainVersionChecker.isAbove1_7() || clazz.isAnnotationPresent(NeedMC1_8.class) && !CertainVersionChecker.isAbove1_8()) continue;
                    if (clazz.isAnnotationPresent(NeedsOtherPlugins.class)) {
                        boolean doBreak = false;
                        String[] stringArray = clazz.getAnnotation(NeedsOtherPlugins.class).neededPlugins();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String pluginName = stringArray[n2];
                            if (Bukkit.getPluginManager().getPlugin(pluginName) == null) {
                                doBreak = true;
                                break;
                            }
                            ++n2;
                        }
                        if (doBreak) continue;
                    }
                    clazzArray.add(clazz);
                }
                catch (Throwable e) {
                    RacesAndClasses.getPlugin().getDebugLogger().logError("Could not load Java Class: " + element.getName() + ". In: " + jarFile.getName());
                }
            }
            boolean hasImportInfos = false;
            for (Class<?> clazz : clazzArray) {
                try {
                    if (clazz == null) continue;
                    Trait trait = (Trait)clazz.newInstance();
                    boolean isPresent = trait.getClass().getMethod("importTrait", new Class[0]).isAnnotationPresent(TraitInfos.class);
                    if (isPresent) {
                        TraitInfos annotation = trait.getClass().getMethod("importTrait", new Class[0]).getAnnotation(TraitInfos.class);
                        TraitsList.addTraitToList(annotation.traitName(), clazz, annotation.category(), annotation.visible());
                        trait.importTrait();
                        hasImportInfos = true;
                        continue;
                    }
                    throw new AnnotationFormatError("Annotation: Import could not be found for class: " + clazz);
                }
                catch (AnnotationFormatError e) {
                    RacesAndClasses.getPlugin().log(e.getLocalizedMessage());
                }
            }
            jarFile.close();
            if (!hasImportInfos) {
                throw new AnnotationFormatError("Annotation: Import could not be found for file: " + file.getName());
            }
        }
        catch (NoClassDefFoundError e) {
            String message = "Unable to load " + file.getName() + ". Probably it was written for a previous Races version!";
            RacesAndClasses.getPlugin().log(message);
            RacesAndClasses.getPlugin().logStackTrace(message, e);
            return;
        }
        catch (AnnotationFormatError e) {
        }
        catch (Throwable e) {
            String message = "The trait " + file.getName() + " failed to load for an unknown reason.";
            RacesAndClasses.getPlugin().log(message);
            RacesAndClasses.getPlugin().logStackTrace(message, e);
        }
    }

    public static Trait buildTraitWithoutHolderByName(String traitName) {
        try {
            Trait trait = TraitStore.buildTrait(traitName, null);
            TraitStore.registerTrait(trait);
            return trait;
        }
        catch (TraitNotFoundException e) {
            RacesAndClasses.getPlugin().log(e.getLocalizedMessage());
        }
        catch (AnnotationFormatError e) {
            RacesAndClasses.getPlugin().log("Could not find Annotation for: " + traitName);
        }
        catch (Exception e) {
            RacesAndClasses.getPlugin().log("Could not Construct trait: " + traitName);
        }
        return null;
    }
}

