/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.statistics;

import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import java.util.HashMap;
import java.util.Map;

public class StatisticGatherer {
    private final long timeStarted;
    private long eventsTriggeredTotal = 0L;
    private Map<String, Long> traitsTriggersTotal = new HashMap<String, Long>();
    private Map<String, Long> traitTimeNeeded = new HashMap<String, Long>();

    public StatisticGatherer(long timeStarted) {
        this.timeStarted = timeStarted;
    }

    public void eventTriggered() {
        ++this.eventsTriggeredTotal;
    }

    public long getTimeRunning() {
        return System.currentTimeMillis() - this.timeStarted;
    }

    public String getTimeRunningAsString() {
        long diffMSec = System.currentTimeMillis() - this.timeStarted;
        int left = 0;
        int ss = 0;
        int mm = 0;
        int hh = 0;
        int dd = 0;
        left = (int)(diffMSec / 1000L);
        ss = left % 60;
        if ((left /= 60) > 0) {
            mm = left % 60;
            if ((left /= 60) > 0) {
                hh = left % 24;
                if ((left /= 24) > 0) {
                    dd = left;
                }
            }
        }
        String diff = "days: " + Integer.toString(dd) + " hours: " + Integer.toString(hh) + " minutes: " + Integer.toString(mm) + " seconds: " + Integer.toString(ss);
        return diff;
    }

    public long getEventsTriggeredTotal() {
        return this.eventsTriggeredTotal;
    }

    public Map<String, Long> getTraitsTriggersTotal() {
        return this.traitsTriggersTotal;
    }

    public void traitTriggered(Trait trait) {
        String traitName = trait.getName();
        if (!this.traitsTriggersTotal.containsKey(traitName)) {
            this.traitsTriggersTotal.put(traitName, 1L);
        } else {
            long triggers = this.traitsTriggersTotal.get(traitName);
            this.traitsTriggersTotal.put(traitName, triggers + 1L);
        }
    }

    public void eventTime(String name, long timeNeeded) {
        if (this.traitTimeNeeded.containsKey(name)) {
            timeNeeded += this.traitTimeNeeded.get(name).longValue();
        }
        this.traitTimeNeeded.put(name, timeNeeded);
    }

    public Map<String, Long> getTimeNeededTotal() {
        return this.traitTimeNeeded;
    }
}

