/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.standalonegui.gui;

import de.tobiyas.racesandclasses.standalonegui.data.GuiClass;
import de.tobiyas.racesandclasses.standalonegui.data.GuiLoader;
import de.tobiyas.racesandclasses.standalonegui.data.GuiRace;
import de.tobiyas.racesandclasses.standalonegui.data.GuiTrait;
import de.tobiyas.racesandclasses.standalonegui.data.option.AbstractTraitConfigOption;
import de.tobiyas.racesandclasses.standalonegui.data.option.TraitConfigOption;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static JTree raceTree;
    private static JTree classTree;
    private JPanel rightSide;
    private DefaultMutableTreeNode selectedNode = null;
    private AbstractTraitConfigOption selectedOption = null;

    public MainFrame() {
        this.setPreferredSize(new Dimension(500, 500));
        this.setDefaultCloseOperation(3);
        this.buildUI();
        MainFrame.rebuildTree();
        this.pack();
        this.setVisible(true);
    }

    private void buildUI() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedNode;
                TreePath selectedPath;
                String command = e.getActionCommand();
                if (command == null || command.isEmpty()) {
                    return;
                }
                if (command.equals("LOAD")) {
                    GuiLoader.openBaseFileSelection();
                    MainFrame.rebuildTree();
                    return;
                }
                if (command.equals("SAVE")) {
                    GuiLoader.save();
                    JOptionPane.showMessageDialog(null, "Save done!");
                    return;
                }
                if (command.equals("REMOVERACE")) {
                    if (raceTree == null || raceTree.getSelectionModel() == null) {
                        return;
                    }
                    selectedPath = raceTree.getSelectionModel().getSelectionPath();
                    if (selectedPath == null) {
                        return;
                    }
                    selectedNode = selectedPath.getLastPathComponent();
                    if (selectedNode == null) {
                        return;
                    }
                    if (selectedNode instanceof DefaultMutableTreeNode) {
                        Object userInfo = ((DefaultMutableTreeNode)selectedNode).getUserObject();
                        if (userInfo instanceof TraitConfigOption) {
                            ((TraitConfigOption)userInfo).reset();
                            MainFrame.this.rebuildSelection();
                            MainFrame.treeUpdated();
                        }
                        return;
                    }
                    if (selectedNode instanceof DefaultMutableTreeNode) {
                        Object userInfo = ((DefaultMutableTreeNode)selectedNode).getUserObject();
                        if (userInfo instanceof GuiTrait) {
                            ((GuiTrait)userInfo).removeFromParent();
                            MainFrame.this.rebuildSelection();
                            MainFrame.treeUpdated();
                        }
                        return;
                    }
                    if (selectedNode instanceof DefaultMutableTreeNode) {
                        Object userInfo = ((DefaultMutableTreeNode)selectedNode).getUserObject();
                        if (userInfo instanceof GuiRace) {
                            ((DefaultMutableTreeNode)selectedNode).removeFromParent();
                            GuiLoader.removeRace((GuiRace)userInfo);
                            MainFrame.rebuildTree();
                        }
                        return;
                    }
                }
                if (command.equals("REMOVECLASS")) {
                    if (classTree == null || classTree.getSelectionModel() == null) {
                        return;
                    }
                    selectedPath = classTree.getSelectionModel().getSelectionPath();
                    if (selectedPath == null) {
                        return;
                    }
                    selectedNode = selectedPath.getLastPathComponent();
                    if (selectedNode == null) {
                        return;
                    }
                    if (selectedNode instanceof DefaultMutableTreeNode) {
                        Object userInfo = ((DefaultMutableTreeNode)selectedNode).getUserObject();
                        if (userInfo instanceof TraitConfigOption) {
                            ((TraitConfigOption)userInfo).reset();
                            MainFrame.this.rebuildSelection();
                            MainFrame.treeUpdated();
                        }
                        return;
                    }
                    if (selectedNode instanceof DefaultMutableTreeNode) {
                        Object userInfo = ((DefaultMutableTreeNode)selectedNode).getUserObject();
                        if (userInfo instanceof GuiClass) {
                            ((DefaultMutableTreeNode)selectedNode).removeFromParent();
                            GuiLoader.removeClass((GuiClass)userInfo);
                            MainFrame.rebuildTree();
                        }
                        return;
                    }
                }
            }
        };
        JLabel titleLabel = new JLabel("Races And Classes Builder");
        titleLabel.setHorizontalAlignment(0);
        this.getContentPane().add((Component)titleLabel, "North");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.5);
        this.getContentPane().add((Component)splitPane, "Center");
        raceTree = new JTree();
        raceTree.setRootVisible(false);
        raceTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e == null || e.getNewLeadSelectionPath() == null) {
                    return;
                }
                Object last = e.getNewLeadSelectionPath().getLastPathComponent();
                if (last == null) {
                    return;
                }
                if (last instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)last;
                    Object obj = node.getUserObject();
                    if (obj != null && obj instanceof AbstractTraitConfigOption) {
                        AbstractTraitConfigOption option = (AbstractTraitConfigOption)obj;
                        MainFrame.this.userSelectedSomething(node, option);
                    } else {
                        MainFrame.this.userUnSelected();
                    }
                }
            }
        });
        JLabel raceHeader = new JLabel("Races");
        JPanel racePanel = new JPanel();
        racePanel.setLayout(new BorderLayout());
        racePanel.add((Component)raceHeader, "North");
        racePanel.add((Component)new JScrollPane(raceTree), "Center");
        JPanel raceControl = new JPanel();
        raceControl.setLayout(new BorderLayout());
        JButton removeButton = new JButton("Remove");
        removeButton.setActionCommand("REMOVERACE");
        removeButton.addActionListener(listener);
        raceControl.add((Component)removeButton, "East");
        JButton addButton = new JButton("Add");
        addButton.setActionCommand("ADDRACE");
        addButton.addActionListener(listener);
        raceControl.add((Component)addButton, "West");
        racePanel.add((Component)raceControl, "South");
        classTree = new JTree();
        classTree.setRootVisible(false);
        classTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object last = e.getNewLeadSelectionPath().getLastPathComponent();
                if (last instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)last;
                    Object obj = node.getUserObject();
                    if (obj != null && obj instanceof AbstractTraitConfigOption) {
                        AbstractTraitConfigOption option = (AbstractTraitConfigOption)obj;
                        MainFrame.this.userSelectedSomething(node, option);
                    } else {
                        MainFrame.this.userUnSelected();
                    }
                }
            }
        });
        JLabel classHeader = new JLabel("Classes");
        JPanel classPanel = new JPanel();
        classPanel.setLayout(new BorderLayout());
        classPanel.add((Component)classHeader, "North");
        classPanel.add((Component)new JScrollPane(classTree), "Center");
        JPanel classControl = new JPanel();
        classControl.setLayout(new BorderLayout());
        removeButton = new JButton("Remove");
        removeButton.setActionCommand("REMOVECLASS");
        removeButton.addActionListener(listener);
        classControl.add((Component)removeButton, "East");
        addButton = new JButton("Add");
        addButton.setActionCommand("ADDCLASS");
        addButton.addActionListener(listener);
        classControl.add((Component)addButton, "West");
        classPanel.add((Component)classControl, "South");
        JSplitPane rcSplit = new JSplitPane(0);
        rcSplit.setTopComponent(racePanel);
        rcSplit.setBottomComponent(classPanel);
        rcSplit.setResizeWeight(0.5);
        splitPane.setLeftComponent(rcSplit);
        this.rightSide = new JPanel();
        this.rightSide.setLayout(new BorderLayout(0, 0));
        splitPane.setRightComponent(this.rightSide);
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        panel.setLayout(new BorderLayout(0, 0));
        JButton saveButton = new JButton("Save");
        panel.add((Component)saveButton, "West");
        JButton loadButton = new JButton("Load");
        panel.add((Component)loadButton, "East");
        JLabel lblNewLabel = new JLabel("by tobiyas");
        lblNewLabel.setHorizontalAlignment(0);
        panel.add((Component)lblNewLabel, "Center");
        loadButton.setActionCommand("LOAD");
        loadButton.addActionListener(listener);
        saveButton.setActionCommand("SAVE");
        saveButton.addActionListener(listener);
    }

    protected void userSelectedSomething(DefaultMutableTreeNode node, AbstractTraitConfigOption obj) {
        this.selectedNode = node;
        this.selectedOption = obj;
        this.rebuildSelection();
    }

    protected void userUnSelected() {
        if (this.selectedNode == null || this.selectedOption == null) {
            return;
        }
        this.selectedNode = null;
        this.selectedOption = null;
        this.rebuildSelection();
    }

    private void rebuildSelection() {
        boolean empty;
        this.rightSide.removeAll();
        boolean bl = empty = this.selectedNode == null || this.selectedOption == null;
        if (empty) {
            this.rightSide.add(new JPanel());
        } else {
            this.selectedOption.addWithConfigOption(this.rightSide);
        }
        this.rightSide.revalidate();
    }

    public static void treeUpdated() {
        if (raceTree != null) {
            raceTree.revalidate();
        }
        if (classTree != null) {
            classTree.revalidate();
        }
    }

    public static void rebuildTree() {
        DefaultMutableTreeNode racesNode = new DefaultMutableTreeNode("Races");
        DefaultMutableTreeNode classesNode = new DefaultMutableTreeNode("Classes");
        DefaultTreeModel raceModel = (DefaultTreeModel)raceTree.getModel();
        DefaultTreeModel classModel = (DefaultTreeModel)classTree.getModel();
        for (GuiRace race : GuiLoader.getLoadedRaces()) {
            DefaultMutableTreeNode raceNode = new DefaultMutableTreeNode(race);
            raceNode.setUserObject(race);
            raceNode.add(MainFrame.getForConfig(race));
            raceNode.add(MainFrame.getForTraits(new LinkedList<GuiTrait>(race.getTraits())));
            racesNode.add(raceNode);
        }
        for (GuiClass clazz : GuiLoader.getLoadedClasses()) {
            DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(clazz.getClassName());
            classNode.setUserObject(clazz);
            classNode.add(MainFrame.getForConfig(clazz));
            classNode.add(MainFrame.getForTraits(new LinkedList<GuiTrait>(clazz.getTraits())));
            classesNode.add(classNode);
        }
        raceModel.setRoot(racesNode);
        classModel.setRoot(classesNode);
        raceModel.reload();
        classModel.reload();
    }

    private static MutableTreeNode getForConfig(GuiClass clazz) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Configuration");
        for (TraitConfigOption option : clazz.getConfig()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(option);
            root.add(node);
        }
        return root;
    }

    private static MutableTreeNode getForConfig(GuiRace race) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Configuration");
        for (TraitConfigOption option : race.getConfig()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(option);
            root.add(node);
        }
        return root;
    }

    private static DefaultMutableTreeNode getForTraits(List<GuiTrait> traits) {
        DefaultMutableTreeNode traitsNode = new DefaultMutableTreeNode("Traits");
        Collections.sort(traits);
        for (GuiTrait trait : traits) {
            DefaultMutableTreeNode traitNode;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(trait.getTraitType());
            DefaultMutableTreeNode needed = new DefaultMutableTreeNode("Needed Options");
            DefaultMutableTreeNode optional = new DefaultMutableTreeNode("Optional Options");
            node.add(needed);
            node.add(optional);
            for (TraitConfigOption option : trait.getTraitConfigurationNeeded()) {
                traitNode = new DefaultMutableTreeNode(option.toString());
                traitNode.setUserObject(option);
                needed.add(traitNode);
            }
            for (TraitConfigOption option : trait.getTraitConfigurationOptional()) {
                traitNode = new DefaultMutableTreeNode(option.toString());
                traitNode.setUserObject(option);
                optional.add(traitNode);
            }
            traitsNode.add(node);
        }
        return traitsNode;
    }
}

